/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reduction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.reduction.ModelReducer;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class DuplicateRemover {
    public static LogicalModel removeDuplicateComponents(LogicalModel model) {
        MDDManager ddmanager = model.getMDDManager();
        List<NodeInfo> nodes = model.getComponents();
        int[] functions = model.getLogicalFunctions();
        int[] newFunctions = (int[])functions.clone();
        HashMap<Integer, Integer> m_functions = new HashMap<Integer, Integer>();
        ArrayList<Integer> duplicates = new ArrayList<Integer>();
        for (int i = functions.length - 1; i >= 0; --i) {
            int n = functions[i];
            if (m_functions.containsKey(n)) {
                int ref = (Integer)m_functions.get(n);
                MDDVariable var = ddmanager.getVariableForKey((Object)nodes.get(ref));
                if (var.nbval == 2) {
                    newFunctions[i] = var.getNode(0, 1);
                } else {
                    int[] values = new int[var.nbval];
                    for (int k = 0; k < values.length; ++k) {
                        values[k] = k;
                    }
                    newFunctions[i] = var.getNode(values);
                }
                duplicates.add(i);
                continue;
            }
            m_functions.put(n, i);
        }
        if (duplicates.size() == 0) {
            return model;
        }
        LogicalModelImpl newModel = new LogicalModelImpl(nodes, ddmanager, newFunctions);
        ModelReducer reducer = new ModelReducer(newModel);
        Iterator iterator = duplicates.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            reducer.remove(i);
        }
        return reducer.getModel();
    }
}

