/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reduction;

import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.perturbation.RegulatorRemovalOperation;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class FixedComponentRemover {
    public static LogicalModel reduceFixed(LogicalModel model, boolean removeFixed) {
        MDDManager ddmanager = model.getMDDManager();
        int[] oldFunctions = model.getLogicalFunctions();
        int[] functions = new int[oldFunctions.length];
        for (int i = 0; i < functions.length; ++i) {
            int f = oldFunctions[i];
            ddmanager.use(f);
            functions[i] = f;
        }
        int[] oldExtraFunctions = model.getExtraLogicalFunctions();
        int[] extraFunctions = new int[oldExtraFunctions.length];
        for (int i = 0; i < extraFunctions.length; ++i) {
            int f = oldExtraFunctions[i];
            ddmanager.use(f);
            extraFunctions[i] = f;
        }
        boolean[] knownFixed = new boolean[functions.length];
        boolean changed = false;
        boolean hasNewFixed = true;
        while (hasNewFixed) {
            hasNewFixed = false;
            for (int i = 0; i < functions.length; ++i) {
                int newFunc;
                int curFunc;
                int j;
                int f = functions[i];
                if (knownFixed[i] || !ddmanager.isleaf(f)) continue;
                knownFixed[i] = true;
                hasNewFixed = true;
                MDDVariable var = ddmanager.getAllVariables()[i];
                RegulatorRemovalOperation op = new RegulatorRemovalOperation(ddmanager, var, f);
                for (j = 0; j < functions.length; ++j) {
                    curFunc = functions[j];
                    newFunc = op.restrict(curFunc);
                    if (newFunc != curFunc) {
                        changed = true;
                        ddmanager.free(curFunc);
                        functions[j] = newFunc;
                        continue;
                    }
                    ddmanager.free(newFunc);
                }
                for (j = 0; j < extraFunctions.length; ++j) {
                    curFunc = extraFunctions[j];
                    newFunc = op.restrict(curFunc);
                    if (newFunc != curFunc) {
                        changed = true;
                        ddmanager.free(curFunc);
                        extraFunctions[j] = newFunc;
                        continue;
                    }
                    ddmanager.free(newFunc);
                }
            }
        }
        if (changed) {
            List<NodeInfo> core = model.getComponents();
            List<NodeInfo> extra = model.getExtraComponents();
            if (removeFixed) {
                for (int i = knownFixed.length - 1; i >= 0; --i) {
                    if (!knownFixed[i]) continue;
                    NodeInfo ni = core.remove(i);
                    extra.add(0, ni);
                }
                int[] newFunctions = new int[core.size()];
                int[] newExtraFunctions = new int[extra.size()];
                int e = extraFunctions.length;
                System.arraycopy(extraFunctions, 0, newExtraFunctions, 0, e);
                int n = 0;
                for (int i = 0; i < knownFixed.length; ++i) {
                    if (!knownFixed[i]) {
                        newFunctions[n] = functions[i];
                        ++n;
                        continue;
                    }
                    newExtraFunctions[e] = functions[i];
                    ++e;
                }
                functions = newFunctions;
                extraFunctions = newExtraFunctions;
            }
            LogicalModelImpl newModel = new LogicalModelImpl(ddmanager, core, functions, extra, extraFunctions);
            return newModel;
        }
        for (int f : functions) {
            ddmanager.free(f);
        }
        for (int f : extraFunctions) {
            ddmanager.free(f);
        }
        return model;
    }
}

