/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reduction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.reduction.ReduceOperation;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class ModelReducer {
    private final MDDManager ddmanager;
    private final ReduceOperation rop;
    private final List<NodeInfo> allNodes;
    private final MDDVariable[] variables;
    private final int[] allFunctions;
    private final int coreSize;
    private final boolean[] removed;
    private final Map<MDDVariable, Set<Integer>> targets;

    public ModelReducer(LogicalModel model) {
        this.ddmanager = model.getMDDManager();
        this.rop = new ReduceOperation(this.ddmanager);
        this.variables = this.ddmanager.getAllVariables();
        this.allNodes = new ArrayList<NodeInfo>(model.getComponents());
        this.allNodes.addAll(model.getExtraComponents());
        int[] functions = model.getLogicalFunctions();
        int[] extraFunctions = model.getExtraLogicalFunctions();
        this.coreSize = functions.length;
        this.targets = new HashMap<MDDVariable, Set<Integer>>();
        this.allFunctions = new int[functions.length + extraFunctions.length];
        int curIdx = 0;
        for (int f : model.getLogicalFunctions()) {
            this.addRegulators(curIdx, f);
            this.ddmanager.use(f);
            ++curIdx;
        }
        for (int f : extraFunctions) {
            this.addRegulators(curIdx, f);
            this.ddmanager.use(f);
            ++curIdx;
        }
        this.removed = new boolean[functions.length];
    }

    public int removePseudoOutputs() {
        return this.removePseudoOutputs(true);
    }

    public int removePseudoOutputs(boolean preserveFixedInputs) {
        int[] targetCount = new int[this.coreSize];
        Set[] regulators = new Set[this.allFunctions.length];
        for (int i = 0; i < this.coreSize; ++i) {
            MDDVariable curVar = this.variables[i];
            Set<Integer> curTargets = this.targets.get(curVar);
            if (curTargets == null) {
                targetCount[i] = 0;
                continue;
            }
            targetCount[i] = curTargets.size();
            Integer I = i;
            for (int tgt : curTargets) {
                HashSet<Integer> curRegs = regulators[tgt];
                if (curRegs == null) {
                    regulators[tgt] = curRegs = new HashSet<Integer>();
                }
                curRegs.add(I);
            }
        }
        HashSet<Integer> outputs = new HashSet<Integer>();
        for (int i = 0; i < targetCount.length; ++i) {
            if (targetCount[i] != 0) continue;
            outputs.add(i);
        }
        HashSet<Integer> pseudoOutputs = new HashSet<Integer>();
        HashSet<Integer> newOutputs = outputs;
        while (newOutputs.size() > 0) {
            HashSet<Integer> curOutputs = newOutputs;
            newOutputs = new HashSet();
            for (int idx : curOutputs) {
                Set regs = regulators[idx];
                if (regs == null) continue;
                Iterator iterator = regulators[idx].iterator();
                while (iterator.hasNext()) {
                    int regIdx = (Integer)iterator.next();
                    if (preserveFixedInputs && this.ddmanager.isleaf(this.allFunctions[regIdx])) continue;
                    int n = regIdx;
                    targetCount[n] = targetCount[n] - 1;
                    if (targetCount[regIdx] != 0) continue;
                    pseudoOutputs.add(regIdx);
                    newOutputs.add(regIdx);
                }
            }
        }
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            this.remove(idx);
        }
        iterator = pseudoOutputs.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            this.remove(idx);
        }
        return pseudoOutputs.size();
    }

    public void remove(int varIdx) {
        MDDVariable var = this.variables[varIdx];
        Set<Integer> varTargets = this.targets.get(var);
        if (varTargets == null) {
            this.removed[varIdx] = true;
            return;
        }
        int regulator = this.allFunctions[varIdx];
        for (int nodeIdx : varTargets) {
            int f = this.allFunctions[nodeIdx];
            int newFunction = this.rop.remove(f, regulator, var);
            this.ddmanager.free(f);
            this.addRegulators(nodeIdx, newFunction);
        }
        this.targets.remove(var);
        this.removed[varIdx] = true;
    }

    private void addRegulators(int nodeIdx, int function) {
        this.allFunctions[nodeIdx] = function;
        boolean[] regulators = this.ddmanager.collectDecisionVariables(function);
        for (int j = 0; j < regulators.length; ++j) {
            if (!regulators[j]) continue;
            MDDVariable var = this.variables[j];
            Set<Integer> varTargets = this.targets.get(var);
            if (varTargets == null) {
                varTargets = new HashSet<Integer>();
                this.targets.put(var, varTargets);
            }
            varTargets.add(nodeIdx);
        }
    }

    public LogicalModel getModel() {
        return this.getModel(true);
    }

    public LogicalModel getModel(boolean includeExtra) {
        return this.getModel(true, includeExtra);
    }

    public LogicalModel getModel(boolean preserveFixedInputs, boolean includeExtra) {
        int countCore = 0;
        boolean[] inCore = new boolean[this.allFunctions.length];
        for (int i = 0; i < this.variables.length; ++i) {
            MDDVariable var = this.variables[i];
            Set<Integer> varTargets = this.targets.get(var);
            if (this.removed[i] && (!preserveFixedInputs || !this.ddmanager.isleaf(this.allFunctions[i]))) continue;
            inCore[i] = true;
            ++countCore;
        }
        int[] coreFunctions = new int[countCore];
        ArrayList<MDDVariable> newVariables = new ArrayList<MDDVariable>();
        ArrayList<NodeInfo> coreNodes = new ArrayList<NodeInfo>(countCore);
        int[] extraFunctions = new int[this.allFunctions.length - countCore];
        ArrayList<NodeInfo> extraNodes = new ArrayList<NodeInfo>(extraFunctions.length);
        for (int i = 0; i < this.variables.length; ++i) {
            NodeInfo ni = this.allNodes.get(i);
            int function = this.allFunctions[i];
            if (inCore[i]) {
                newVariables.add(this.variables[i]);
                coreFunctions[coreNodes.size()] = function;
                coreNodes.add(ni);
                continue;
            }
            extraFunctions[extraNodes.size()] = function;
            extraNodes.add(ni);
        }
        MDDManager newDDManager = this.ddmanager.getManager(newVariables);
        if (includeExtra) {
            return new LogicalModelImpl(newDDManager, coreNodes, coreFunctions, extraNodes, extraFunctions);
        }
        return new LogicalModelImpl(coreNodes, newDDManager, coreFunctions);
    }
}

