/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reduction;

import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class ReduceOperation {
    private final MDDManager ddmanager;

    public ReduceOperation(MDDManager ddmanager) {
        this.ddmanager = ddmanager;
    }

    public int remove(int node, int regulator, MDDVariable rmVar) {
        int[] next;
        MDDVariable nextVariable;
        MDDVariable nvar = this.ddmanager.getNodeVariable(node);
        if (nvar == null || nvar.after(rmVar)) {
            return node;
        }
        MDDVariable regVar = this.ddmanager.getNodeVariable(regulator);
        if (nvar == rmVar) {
            if (regVar == null) {
                return this.ddmanager.getChild(node, regulator);
            }
            if (regVar == rmVar) {
                throw new RuntimeException("Can not continue the simplification: a circuit would get lost");
            }
            return this.remove(this.ddmanager.getChildren(node), regulator);
        }
        if (regVar == null || regVar.after(nvar)) {
            nextVariable = nvar;
            next = new int[nextVariable.nbval];
            for (int i = 0; i < next.length; ++i) {
                next[i] = this.remove(this.ddmanager.getChild(node, i), regulator, rmVar);
            }
        } else if (nvar.after(regVar)) {
            nextVariable = regVar;
            next = new int[nextVariable.nbval];
            for (int i = 0; i < next.length; ++i) {
                next[i] = this.remove(node, this.ddmanager.getChild(regulator, i), rmVar);
            }
        } else {
            nextVariable = nvar;
            next = new int[nextVariable.nbval];
            for (int i = 0; i < next.length; ++i) {
                next[i] = this.remove(this.ddmanager.getChild(node, i), this.ddmanager.getChild(regulator, i), rmVar);
            }
        }
        return nextVariable.getNode(next);
    }

    private int remove(int[] t_ori, int regulator) {
        MDDVariable regVar;
        if (this.ddmanager.isleaf(regulator)) {
            return t_ori[regulator];
        }
        MDDVariable bestVar = regVar = this.ddmanager.getNodeVariable(regulator);
        int index = -1;
        for (int i = 0; i < t_ori.length; ++i) {
            MDDVariable nvar = this.ddmanager.getNodeVariable(t_ori[i]);
            if (nvar == null || nvar.after(bestVar)) continue;
            bestVar = nvar;
            index = i;
        }
        int[] next = new int[bestVar.nbval];
        if (index == -1) {
            for (int i = 0; i < bestVar.nbval; ++i) {
                next[i] = this.remove(t_ori, this.ddmanager.getChild(regulator, i));
            }
        } else {
            for (int i = 0; i < bestVar.nbval; ++i) {
                int[] t_recur = new int[t_ori.length];
                for (int j = 0; j < t_recur.length; ++j) {
                    int node = t_ori[j];
                    MDDVariable nvar = this.ddmanager.getNodeVariable(node);
                    t_recur[j] = nvar == null || nvar.after(bestVar) ? node : this.ddmanager.getChild(node, i);
                }
                next[i] = regVar == bestVar ? this.remove(t_recur, this.ddmanager.getChild(regulator, i)) : this.remove(t_recur, regulator);
            }
        }
        return bestVar.getNode(next);
    }
}

