/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reduction;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.helper.state.StatePattern;
import org.colomoto.biolqm.modifier.BaseModifier;
import org.colomoto.biolqm.modifier.reduction.DuplicateRemover;
import org.colomoto.biolqm.modifier.reduction.FixedComponentRemover;
import org.colomoto.biolqm.modifier.reduction.ModelReducer;
import org.colomoto.biolqm.modifier.reduction.PatternReduction;

public class ReductionModifier
extends BaseModifier {
    private final LogicalModel model;
    public boolean handleFixed = false;
    public boolean purgeFixed = false;
    public boolean handleDuplicates = false;
    public boolean handleOutputs = false;
    public boolean keepExtra = true;
    public StatePattern pattern = null;
    public boolean forcePattern = false;

    public ReductionModifier(LogicalModel model) {
        this.model = model;
    }

    public ReductionModifier(LogicalModel model, String parameters) {
        this.model = model;
        this.setParameters(parameters);
    }

    @Override
    public void setParameters(String[] options) {
        for (String o : options) {
            if (o.startsWith(":")) {
                o = o.substring(1);
            }
            if ("fixed".equalsIgnoreCase(o)) {
                this.handleFixed = true;
                continue;
            }
            if ("purge".equalsIgnoreCase(o)) {
                this.purgeFixed = true;
                continue;
            }
            if ("duplicate".equalsIgnoreCase(o)) {
                this.handleDuplicates = true;
                continue;
            }
            if ("output".equalsIgnoreCase(o)) {
                this.handleOutputs = true;
                continue;
            }
            if (!"no-extra".equalsIgnoreCase(o)) continue;
            this.keepExtra = false;
        }
    }

    public boolean hasReduction() {
        return this.handleFixed || this.purgeFixed || this.handleDuplicates || this.handleOutputs || this.pattern != null;
    }

    @Override
    public LogicalModel performTask() throws Exception {
        if (!this.hasReduction()) {
            return this.model;
        }
        ModelReducer reducer = new ModelReducer(this.model);
        if (this.handleOutputs) {
            reducer.removePseudoOutputs();
        }
        LogicalModel result = reducer.getModel();
        if (this.pattern != null) {
            // empty if block
        }
        if (this.pattern != null) {
            result = (LogicalModel)new PatternReduction(result, this.pattern).call();
        }
        if (this.handleFixed) {
            result = FixedComponentRemover.reduceFixed(result, this.purgeFixed);
        }
        if (this.handleDuplicates) {
            result = DuplicateRemover.removeDuplicateComponents(result);
        }
        if (!this.keepExtra && result.getExtraComponents().size() > 0) {
            result = result.clone(false);
        }
        return result;
    }
}

