/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.reverse;

import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class ReverseOperation {
    private final MDDManager manager;

    public ReverseOperation(MDDManager manager) {
        this.manager = manager;
    }

    public int reverse(MDDVariable var, int node) {
        MDDVariable curvar = this.manager.getNodeVariable(node);
        if (var.after(curvar)) {
            byte n = curvar.nbval;
            if (n == 2) {
                int c0 = this.reverse(var, this.manager.getChild(node, 0));
                int c1 = this.reverse(var, this.manager.getChild(node, 1));
                int newNode = curvar.getNode(c0, c1);
                this.manager.free(c0);
                this.manager.free(c1);
                return newNode;
            }
            throw new RuntimeException("Reverse only applies to Boolean functions");
        }
        if (curvar == var) {
            int c0 = this.manager.not(this.manager.getChild(node, 1));
            int c1 = this.manager.not(this.manager.getChild(node, 0));
            int newNode = curvar.getNode(c0, c1);
            this.manager.free(c0);
            this.manager.free(c1);
            return newNode;
        }
        return this.manager.not(node);
    }
}

