/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.sanitize;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.BaseModifier;

public class SanitizeModifier
extends BaseModifier {
    private final LogicalModel model;
    private boolean sanitizeIDs = true;
    private final Map<String, NodeInfo> uids = new HashMap<String, NodeInfo>();
    private static final Pattern NONLATIN = Pattern.compile("[^\\w_]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    public SanitizeModifier(LogicalModel model) {
        this.model = model;
    }

    @Override
    public LogicalModel performTask() {
        if (this.sanitizeIDs) {
            this.sanitizeIDs(this.model.getComponents());
            this.sanitizeIDs(this.model.getExtraComponents());
        }
        return this.model;
    }

    @Override
    public void setParameters(String[] options) {
        for (String o : options) {
            boolean b = true;
            if (o.startsWith(":")) {
                o = o.substring(1);
            } else if (o.startsWith("!") || o.startsWith("^")) {
                o = o.substring(1);
                b = false;
            }
            if (!"name2id".equalsIgnoreCase(o)) continue;
            this.setSanitizeIDs(b);
        }
    }

    public boolean isSanitizeIDs() {
        return this.sanitizeIDs;
    }

    public void setSanitizeIDs(boolean b) {
        this.sanitizeIDs = b;
    }

    private void sanitizeIDs(List<NodeInfo> components) {
        for (NodeInfo ni : components) {
            String name = ni.getName();
            if (name == null || name.length() == 0) {
                String uid = ni.getNodeID();
                NodeInfo oni = this.uids.get(uid);
                this.uids.put(uid, ni);
                if (oni == null) continue;
                this.ensureUniqueID(oni);
                continue;
            }
            this.ensureUniqueID(ni);
        }
    }

    private void ensureUniqueID(NodeInfo ni) {
        String uid = ni.getNodeID();
        String name = ni.getName();
        if (name != null && name.length() > 0) {
            String nowhitespace = WHITESPACE.matcher(name).replaceAll("_");
            String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
            uid = NONLATIN.matcher(normalized).replaceAll("");
        }
        String baseUid = uid;
        int tag = 1;
        while (this.uids.containsKey(uid)) {
            uid = baseUid + "_" + ++tag;
        }
        ni.setNodeID(uid);
        this.uids.put(uid, ni);
    }
}

