/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.modifier.submodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.LogicalModelImpl;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.modifier.BaseModifier;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

public class SubmodelModifier
extends BaseModifier {
    private final LogicalModel model;
    private ArrayList<NodeInfo> compToExtract;

    public SubmodelModifier(LogicalModel model) {
        this.model = model;
        this.compToExtract = null;
    }

    @Override
    public LogicalModel performTask() {
        if (this.compToExtract.size() == 0) {
            return this.model;
        }
        MDDManager mddManager = this.model.getMDDManager();
        int[] functions = this.model.getLogicalFunctions();
        List<NodeInfo> allModelComponents = this.model.getComponents();
        int nb_components = allModelComponents.size();
        boolean[] belongsToSubmodel = new boolean[nb_components];
        for (int i = 0; i < nb_components; ++i) {
            if (!this.compToExtract.contains(allModelComponents.get(i))) continue;
            belongsToSubmodel[i] = true;
            boolean[] isDV = mddManager.collectDecisionVariables(functions[i]);
            for (int j = 0; j < nb_components; ++j) {
                belongsToSubmodel[j] = belongsToSubmodel[j] || isDV[j];
            }
        }
        int new_components = 0;
        for (int i = 0; i < nb_components; ++i) {
            if (!belongsToSubmodel[i]) continue;
            ++new_components;
        }
        ArrayList<NodeInfo> submodelNodes = new ArrayList<NodeInfo>(new_components);
        int[] submodelFunctions = new int[new_components];
        int i_new = 0;
        for (int i = 0; i < nb_components; ++i) {
            if (!belongsToSubmodel[i]) continue;
            NodeInfo currentNodeInfo = allModelComponents.get(i);
            submodelNodes.add(currentNodeInfo);
            if (!mddManager.isleaf(functions[i]) && !this.compToExtract.contains(currentNodeInfo)) {
                int autoreg;
                MDDVariable var = mddManager.getVariableForKey((Object)currentNodeInfo);
                if (var.nbval == 2) {
                    autoreg = var.getNode(0, 1);
                } else {
                    int[] vals = new int[var.nbval];
                    for (int val = 0; val < var.nbval; ++val) {
                        vals[val] = val;
                    }
                    autoreg = var.getNode(vals);
                }
                submodelFunctions[i_new++] = autoreg;
                continue;
            }
            submodelFunctions[i_new++] = functions[i];
        }
        return new LogicalModelImpl(submodelNodes, mddManager, submodelFunctions);
    }

    @Override
    public void setParameters(String[] parameters) {
        ArrayList<NodeInfo> validNodes = new ArrayList<NodeInfo>();
        ArrayList<String> invalidNodes = new ArrayList<String>();
        for (String p : parameters) {
            NodeInfo ninf = this.model.getComponent(p);
            if (ninf == null) {
                invalidNodes.add(p);
                continue;
            }
            validNodes.add(ninf);
        }
        if (invalidNodes.size() > 0) {
            System.out.println("Warning: Invalid nodes will be ignored: " + String.join((CharSequence)", ", invalidNodes));
        }
        if (parameters.length == 0 || validNodes.size() == 0) {
            System.out.println("Warning: No parameters to extract. Full model will be returned.");
        }
        if (new LinkedHashSet<String>(Arrays.asList(parameters)).size() < parameters.length) {
            System.out.println("Warning: Duplicated parameters.");
        }
        this.compToExtract = validNodes;
    }
}

