/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.service;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ExtensionLoader {
    private static ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
    private static ClassLoader cld = null;

    public static ClassLoader getClassLoader() {
        if (cld == null) {
            return systemLoader;
        }
        return cld;
    }

    public static void loadExtensions(String ename, Class<?> cl) {
        if (cld != null) {
            return;
        }
        String basedir = null;
        String clname = cl.getName().replace(".", "/") + ".class";
        String path = cl.getClassLoader().getResource(clname).toString();
        if (path.startsWith("file:")) {
            basedir = path.substring(5, path.length() - clname.length());
        } else if (path.startsWith("jar:file:")) {
            File jar = new File(path.substring(9, path.length() - clname.length() - 2));
            basedir = jar.getParent();
        }
        if (ename == null) {
            cld = systemLoader;
            return;
        }
        File extensionDir = new File(basedir, ename);
        if (!extensionDir.isDirectory()) {
            cld = systemLoader;
            return;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getPath().toLowerCase().endsWith(".jar");
            }
        };
        File[] files = extensionDir.listFiles(filter);
        try {
            URL[] urls = new URL[files.length];
            int i = 0;
            for (File f : files) {
                urls[i++] = f.toURI().toURL();
                System.out.println("   " + f.getName());
            }
            cld = new URLClassLoader(urls, systemLoader);
        }
        catch (IOException e) {
            System.err.println("Could not load extension files");
            cld = systemLoader;
        }
        if (cld != null && cld != systemLoader) {
            Thread.currentThread().setContextClassLoader(cld);
        }
    }

    private static <T> ServiceLoader<T> load(Class<T> cl) {
        return ServiceLoader.load(cl, ExtensionLoader.getClassLoader());
    }

    public static <T> List<T> load_instances(Class<T> cl) {
        Iterator<T> it = ExtensionLoader.load(cl).iterator();
        ArrayList<T> loaded = new ArrayList<T>();
        while (it.hasNext()) {
            try {
                T element = it.next();
                if (element == null) continue;
                loaded.add(element);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        return loaded;
    }
}

