/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.service;

import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.colomoto.biolqm.LQMLauncher;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.io.LogicalModelFormat;
import org.colomoto.biolqm.modifier.ModelModifierService;
import org.colomoto.biolqm.modifier.booleanize.BooleanizeService;
import org.colomoto.biolqm.service.ExtensionLoader;
import org.colomoto.biolqm.service.Service;
import org.colomoto.biolqm.tool.ModelToolService;

public class LQMServiceManager {
    private static final List<LogicalModelFormat> formats = ExtensionLoader.load_instances(LogicalModelFormat.class);
    private static final List<ModelToolService> tools = ExtensionLoader.load_instances(ModelToolService.class);
    private static final List<ModelModifierService> modifiers = ExtensionLoader.load_instances(ModelModifierService.class);
    private static final Map<String, LogicalModelFormat> id2format = new HashMap<String, LogicalModelFormat>();
    private static final Map<String, ModelToolService> id2tool = new HashMap<String, ModelToolService>();
    private static final Map<String, ModelModifierService> id2modifier = new HashMap<String, ModelModifierService>();
    private static Map<Class, Service> byClass = new HashMap<Class, Service>();
    public final String[] args;

    public LQMServiceManager(String[] args) {
        this.args = args;
    }

    private static <T extends Service> void loadServices(List<T> services, Map<String, T> idmap) {
        for (Service srv : services) {
            idmap.put(srv.getID(), srv);
            byClass.put(srv.getClass(), srv);
        }
        LQMServiceManager.fillAliases(idmap, services);
    }

    private static <T extends Service> void fillAliases(Map<String, T> map, List<T> services) {
        for (Service srv : services) {
            String[] aliases = srv.getAliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (map.containsKey(alias)) continue;
                map.put(alias, srv);
            }
        }
    }

    public static LogicalModelFormat getFormat(String name) {
        return id2format.get(name);
    }

    public static Iterable<LogicalModelFormat> getFormats() {
        return formats;
    }

    public static ModelToolService getTool(String name) {
        return id2tool.get(name);
    }

    public static Iterable<ModelToolService> getTools() {
        return tools;
    }

    public static ModelModifierService getModifier(String name) {
        return id2modifier.get(name);
    }

    public static <T> T get(Class<T> cl) {
        return (T)byClass.get(cl);
    }

    public static Iterable<ModelModifierService> getModifiers() {
        return modifiers;
    }

    public static boolean register(Service srv) {
        if (srv == null) {
            return false;
        }
        if (LQMServiceManager.register(ModelModifierService.class, srv, modifiers, id2modifier)) {
            return true;
        }
        if (LQMServiceManager.register(ModelToolService.class, srv, tools, id2tool)) {
            return true;
        }
        return LQMServiceManager.register(LogicalModelFormat.class, srv, formats, id2format);
    }

    private static <T> boolean register(Class<T> cl, Service srv, List<T> services, Map<String, T> id2srv) {
        String id = srv.getID();
        if (!cl.isInstance(srv) || id2srv.containsKey(id)) {
            return false;
        }
        services.add(srv);
        id2srv.put(id, srv);
        return true;
    }

    public static LogicalModel load(String filename) {
        return LQMServiceManager.load(filename, null);
    }

    public static LogicalModel modify(LogicalModel model, String name) throws Exception {
        return LQMServiceManager.getModifier(name).modify(model);
    }

    public static LogicalModel modify(LogicalModel model, String name, String parameters) throws Exception {
        return LQMServiceManager.getModifier(name).modify(model, parameters);
    }

    public static FileWriter fileWriter(String path) throws IOException {
        return new FileWriter(path);
    }

    public static LogicalModel load(String filename, String format) {
        LogicalModelFormat inputFormat;
        if (format == null) {
            format = filename.substring(filename.lastIndexOf(".") + 1);
        }
        if ((inputFormat = LQMLauncher.getFormat(format)) == null) {
            System.err.println("Format not found: " + format);
            return null;
        }
        try {
            return inputFormat.load(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean save(LogicalModel model, String filename, String format) {
        LogicalModelFormat outputFormat;
        if (format == null) {
            format = filename.substring(filename.lastIndexOf(".") + 1);
        }
        if ((outputFormat = LQMLauncher.getFormat(format)) == null) {
            System.err.println("Format not found: " + format);
            return false;
        }
        try {
            if (!model.isBoolean()) {
                switch (outputFormat.getMultivaluedSupport()) {
                    case BOOLEAN_STRICT: {
                        throw new RuntimeException(outputFormat.getID() + " does not support multivalued models");
                    }
                    case BOOLEANIZED: {
                        System.out.println(outputFormat.getID() + ": export of a booleanized model");
                        model = LQMServiceManager.get(BooleanizeService.class).modify(model);
                    }
                }
            }
            outputFormat.export(model, filename);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        LQMServiceManager.loadServices(formats, id2format);
        LQMServiceManager.loadServices(tools, id2tool);
        LQMServiceManager.loadServices(modifiers, id2modifier);
    }
}

