/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.attractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.AbstractToolTask;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;
import org.colomoto.mddlib.PathSearcher;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class SATAttractorFinder
extends AbstractToolTask<Object> {
    private Map<Integer, ArrayList<ArrayList<Integer>>> dnfFunctions = new HashMap<Integer, ArrayList<ArrayList<Integer>>>();
    private Map<Integer, ArrayList<ArrayList<Integer>>> cnfFunctions = new HashMap<Integer, ArrayList<ArrayList<Integer>>>();
    private Map<Integer, Integer> constants = new HashMap<Integer, Integer>();
    private final int MAXVAR = 1000000;

    public SATAttractorFinder(LogicalModel model) {
        super(model);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object performTask() {
        MDDManager manager = this.model.getMDDManager();
        this.parseModel(this.model);
        this.processConstants();
        if (this.dnfFunctions.size() == 0) {
            System.out.println("Found Constant System:");
            System.out.print("\t");
            boolean first = true;
            for (Map.Entry<Integer, Integer> mapping : this.constants.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    System.out.print(" & ");
                }
                MDDVariable var = manager.getAllVariables()[mapping.getKey() - 1];
                if (mapping.getValue() == 0) {
                    System.out.print("!");
                }
                System.out.print(var.toString());
            }
            return null;
        }
        this.disjunctiveToConjunctive();
        int i = this.dnfFunctions.size() + this.constants.size();
        if (i > 100) {
            i = 100;
        }
        boolean attractorIsFound = false;
        ArrayList allAttractors = new ArrayList();
        ArrayList<ArrayList<Integer>> problem = new ArrayList<ArrayList<Integer>>();
        for (int j = 0; j < i; ++j) {
            this.writeTimeStep(problem, j);
        }
        try {
            void var7_15;
            ISolver solver = SolverFactory.newDefault();
            solver.newVar(1000000);
            solver.setTimeout(30);
            boolean bl = false;
            while (var7_15 < problem.size()) {
                int[] clause = new int[problem.get((int)var7_15).size()];
                for (int j = 0; j < problem.get((int)var7_15).size(); ++j) {
                    clause[j] = problem.get((int)var7_15).get(j);
                }
                solver.addClause((IVecInt)new VecInt(clause));
                ++var7_15;
            }
            while (solver.isSatisfiable()) {
                int j;
                int k;
                int[] nArray = solver.model();
                int numFunctions = this.dnfFunctions.size();
                int offset = this.dnfFunctions.size() + this.constants.size();
                int[][] path = new int[i + 1][numFunctions];
                for (k = 0; k < nArray.length; ++k) {
                    int temp = nArray[k];
                    if (temp < 0) {
                        temp *= -1;
                        temp = (temp - 1) % offset + 1;
                        temp *= -1;
                    } else {
                        temp = (temp - 1) % offset + 1;
                    }
                    path[k / numFunctions][k % numFunctions] = temp;
                }
                for (k = 1; k < path.length; ++k) {
                    boolean match = true;
                    for (int j2 = 0; j2 < path[0].length; ++j2) {
                        if (path[0][j2] == path[k][j2]) continue;
                        match = false;
                    }
                    if (!match) continue;
                    attractorIsFound = true;
                    ArrayList attractor = new ArrayList();
                    for (j = 0; j < k; ++j) {
                        ArrayList<Integer> record = new ArrayList<Integer>();
                        int[] newClause = new int[path[j].length];
                        for (int l = 0; l < newClause.length; ++l) {
                            record.add(path[j][l]);
                            newClause[l] = -1 * path[j][l];
                        }
                        solver.addClause((IVecInt)new VecInt(newClause));
                        attractor.add(record);
                    }
                    allAttractors.add(attractor);
                    break;
                }
                if (attractorIsFound) {
                    attractorIsFound = false;
                    continue;
                }
                ArrayList<ArrayList<Integer>> extendedProblem = new ArrayList<ArrayList<Integer>>();
                for (int j3 = i; j3 < i * 2; ++j3) {
                    this.writeTimeStep(extendedProblem, j3);
                }
                i *= 2;
                for (int k2 = 0; k2 < extendedProblem.size(); ++k2) {
                    int[] clause = new int[extendedProblem.get(k2).size()];
                    for (j = 0; j < extendedProblem.get(k2).size(); ++j) {
                        clause[j] = extendedProblem.get(k2).get(j);
                    }
                    solver.addClause((IVecInt)new VecInt(clause));
                }
            }
        }
        catch (TimeoutException e) {
            System.err.println("Time limit exceeded");
        }
        catch (ContradictionException e) {
            System.err.println("Encountered a contradiction:");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Found " + allAttractors.size() + " attractors");
        for (ArrayList arrayList : allAttractors) {
            System.out.println("Attractor:");
            for (ArrayList state : arrayList) {
                MDDVariable var;
                System.out.print("\t");
                boolean first = true;
                for (Map.Entry<Integer, Integer> mapping : this.constants.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        System.out.print(" & ");
                    }
                    var = manager.getAllVariables()[mapping.getKey() - 1];
                    if (mapping.getValue() == 0) {
                        System.out.print("!");
                    }
                    System.out.print(var.toString());
                }
                Iterator<Map.Entry<Integer, Integer>> iterator = state.iterator();
                while (iterator.hasNext()) {
                    int node = (Integer)((Object)iterator.next());
                    if (first) {
                        first = false;
                    } else {
                        System.out.print(" & ");
                    }
                    if (node > 0) {
                        var = manager.getAllVariables()[node - 1];
                        System.out.print(var.toString());
                        continue;
                    }
                    var = manager.getAllVariables()[(node *= -1) - 1];
                    System.out.print("!" + var.toString());
                }
                System.out.println();
            }
        }
        return null;
    }

    private void processConstants() {
        HashMap<Integer, Integer> allConstants = new HashMap<Integer, Integer>();
        Map<Integer, Integer> forcedConstants = this.constants;
        while (forcedConstants.size() > 0) {
            HashMap<Integer, Integer> newForcedConstants = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> mapping : forcedConstants.entrySet()) {
                ArrayList<ArrayList<Integer>> clausesToRemove;
                ArrayList<Integer> valuesToRemove;
                allConstants.put(mapping.getKey(), mapping.getValue());
                this.dnfFunctions.remove(mapping.getKey());
                if (mapping.getValue() == 0) {
                    valuesToRemove = new ArrayList<Integer>();
                    valuesToRemove.add(-1 * mapping.getKey());
                    for (Map.Entry<Integer, ArrayList<ArrayList<Integer>>> function : this.dnfFunctions.entrySet()) {
                        clausesToRemove = new ArrayList();
                        for (ArrayList<Integer> clause : function.getValue()) {
                            if (clause.contains(mapping.getKey())) {
                                clausesToRemove.add(clause);
                                continue;
                            }
                            clause.removeAll(valuesToRemove);
                            if (clause.size() != 0) continue;
                            newForcedConstants.put(function.getKey(), 1);
                        }
                        function.getValue().removeAll(clausesToRemove);
                        if (function.getValue().size() != 0) continue;
                        newForcedConstants.put(function.getKey(), 0);
                    }
                    continue;
                }
                valuesToRemove = new ArrayList();
                valuesToRemove.add(mapping.getKey());
                for (Map.Entry<Integer, ArrayList<ArrayList<Integer>>> function : this.dnfFunctions.entrySet()) {
                    clausesToRemove = new ArrayList<ArrayList<Integer>>();
                    for (ArrayList<Integer> clause : function.getValue()) {
                        if (clause.contains(-1 * mapping.getKey())) {
                            clausesToRemove.add(clause);
                            continue;
                        }
                        clause.removeAll(valuesToRemove);
                        if (clause.size() != 0) continue;
                        newForcedConstants.put(function.getKey(), 1);
                    }
                    function.getValue().removeAll(clausesToRemove);
                    if (function.getValue().size() != 0) continue;
                    newForcedConstants.put(function.getKey(), 0);
                }
            }
            forcedConstants = newForcedConstants;
        }
        for (Map.Entry<Integer, Integer> mapping : forcedConstants.entrySet()) {
            allConstants.put(mapping.getKey(), mapping.getValue());
            this.dnfFunctions.remove(mapping.getKey());
        }
        this.constants = allConstants;
    }

    /*
     * WARNING - void declaration
     */
    private void disjunctiveToConjunctive() {
        for (Map.Entry<Integer, ArrayList<ArrayList<Integer>>> mapping : this.dnfFunctions.entrySet()) {
            void var8_8;
            HashMap<Integer, Integer> inputs = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> reverseInputs = new HashMap<Integer, Integer>();
            ArrayList cnfFunction = new ArrayList();
            int index = 0;
            for (ArrayList<Integer> arrayList : mapping.getValue()) {
                for (Integer var : arrayList) {
                    if (var < 0) {
                        var = var * -1;
                    }
                    if (inputs.containsKey(var)) continue;
                    inputs.put(var, index);
                    reverseInputs.put(index, var);
                    ++index;
                }
            }
            int[] truthTable = new int[1 << inputs.size()];
            for (ArrayList<Integer> clause3 : mapping.getValue()) {
                ArrayList notFixed = new ArrayList(inputs.keySet());
                int baseIndex = 0;
                for (Integer var : clause3) {
                    if (var < 0) {
                        var = var * -1;
                    } else {
                        baseIndex += 1 << (Integer)inputs.get(var);
                    }
                    notFixed.remove(var);
                }
                for (int i = 0; i < 1 << notFixed.size(); ++i) {
                    int variableIndex = 0;
                    for (int j = 0; j < notFixed.size(); ++j) {
                        if ((i >> j & 1) != 1) continue;
                        variableIndex += 1 << (Integer)inputs.get(notFixed.get(j));
                    }
                    truthTable[baseIndex + variableIndex] = 1;
                }
            }
            boolean bl = false;
            while (var8_8 < truthTable.length) {
                if (truthTable[var8_8] == 0) {
                    ArrayList<Integer> cnfClause = new ArrayList<Integer>();
                    for (int j = 0; j < reverseInputs.size(); ++j) {
                        if ((var8_8 >> j & 1) == 1) {
                            cnfClause.add(-1 * (Integer)reverseInputs.get(j));
                            continue;
                        }
                        cnfClause.add((Integer)reverseInputs.get(j));
                    }
                    cnfFunction.add(cnfClause);
                }
                ++var8_8;
            }
            this.cnfFunctions.put(mapping.getKey(), cnfFunction);
        }
    }

    private void writeTimeStep(ArrayList<ArrayList<Integer>> cnfMatrix, int timeStep) {
        int offset = (this.dnfFunctions.size() + this.constants.size()) * timeStep;
        int futureOffset = (this.dnfFunctions.size() + this.constants.size()) * (timeStep + 1);
        for (Map.Entry<Integer, ArrayList<ArrayList<Integer>>> mapping : this.dnfFunctions.entrySet()) {
            int func = mapping.getKey();
            if (mapping.getValue().get(0).get(0) == 0) continue;
            for (ArrayList<Integer> dnfClause : mapping.getValue()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i : dnfClause) {
                    if (i > 0) {
                        arrayList.add(-1 * (i + futureOffset));
                        continue;
                    }
                    arrayList.add(-1 * (i - futureOffset));
                }
                arrayList.add(func + offset);
                cnfMatrix.add(arrayList);
            }
            ArrayList<ArrayList<Integer>> cnfFunction = this.cnfFunctions.get(func);
            for (ArrayList<Integer> arrayList : cnfFunction) {
                ArrayList<Integer> newClause = new ArrayList<Integer>();
                for (int i : arrayList) {
                    if (i > 0) {
                        newClause.add(i + futureOffset);
                        continue;
                    }
                    newClause.add(i - futureOffset);
                }
                newClause.add(-1 * (func + offset));
                cnfMatrix.add(newClause);
            }
        }
    }

    private void parseModel(LogicalModel model) {
        MDDManager ddmanager = model.getMDDManager();
        MDDVariable[] variables = ddmanager.getAllVariables();
        PathSearcher searcher = new PathSearcher(ddmanager);
        int[] functions = model.getLogicalFunctions();
        for (int idx = 0; idx < functions.length; ++idx) {
            MDDVariable var = variables[idx];
            int function = functions[idx];
            if (ddmanager.isleaf(function)) {
                this.constants.put(idx + 1, function);
                continue;
            }
            int[] path = searcher.setNode(function);
            ArrayList func = new ArrayList();
            Iterator iterator = searcher.iterator();
            while (iterator.hasNext()) {
                int leaf = (Integer)iterator.next();
                if (leaf == 0) continue;
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < path.length; ++i) {
                    int cst = path[i];
                    if (cst < 0) continue;
                    if (cst == 0) {
                        list.add(-1 * (i + 1));
                        continue;
                    }
                    list.add(i + 1);
                }
                func.add(list);
            }
            this.dnfFunctions.put(idx + 1, func);
        }
    }

    @Override
    public void cli() {
        try {
            this.call();
        }
        catch (Exception e) {
            System.err.println("Error while searching for synchronous attractors");
        }
    }
}

