/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.fixpoints;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.helper.state.StateList;
import org.colomoto.mddlib.MDDManager;

public class FixpointList
extends ArrayList<byte[]>
implements StateList {
    private final NodeInfo[] nodes;
    private final NodeInfo[] extraNodes;
    private final NodeInfo[] mergedNodes;
    private final int[] extraFunctions;
    private MDDManager ddmanager;
    private List<byte[]> extra;
    private boolean isExtra = false;

    public FixpointList(LogicalModel model) {
        this(model.getComponents(), model.getExtraComponents(), model.getMDDManager(), model.getExtraLogicalFunctions());
    }

    public FixpointList(List<NodeInfo> nodes) {
        this(nodes, null, null, null);
    }

    public FixpointList(List<NodeInfo> nodes, List<NodeInfo> extraNodes, MDDManager ddmanager, int[] extraFunctions) {
        this.nodes = FixpointList.extractIDs(nodes);
        this.extraNodes = FixpointList.extractIDs(extraNodes);
        if (this.extraNodes == null) {
            this.mergedNodes = this.nodes;
        } else {
            this.mergedNodes = new NodeInfo[this.nodes.length + this.extraNodes.length];
            System.arraycopy(this.nodes, 0, this.mergedNodes, 0, this.nodes.length);
            System.arraycopy(this.extraNodes, 0, this.mergedNodes, this.nodes.length, this.extraNodes.length);
        }
        this.ddmanager = ddmanager;
        this.extraFunctions = extraFunctions;
    }

    public static NodeInfo[] extractIDs(List<NodeInfo> list) {
        if (list == null) {
            return null;
        }
        NodeInfo[] array = new NodeInfo[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    @Override
    public NodeInfo[] getComponents() {
        if (this.isExtra) {
            return this.mergedNodes;
        }
        return this.nodes;
    }

    @Override
    public byte get(int row, int col) {
        if (col < this.nodes.length) {
            return ((byte[])this.get(row))[col];
        }
        return this.extra.get(row)[col - this.nodes.length];
    }

    @Override
    public boolean setExtra(boolean extra) {
        if (extra == this.isExtra) {
            return false;
        }
        this.isExtra = extra;
        if (this.extraNodes == null || this.extraNodes.length == 0) {
            return false;
        }
        if (!this.isExtra) {
            this.extra = null;
            return true;
        }
        this.extra = new ArrayList<byte[]>(this.size());
        for (byte[] state : this) {
            byte[] cur = new byte[this.extraFunctions.length];
            for (int idx = 0; idx < this.extraFunctions.length; ++idx) {
                cur[idx] = this.ddmanager.reach(this.extraFunctions[idx], state);
            }
            this.extra.add(cur);
        }
        return true;
    }

    public List<byte[]> getExtraData() {
        this.setExtra(true);
        return this.extra;
    }

    public byte[] rawByteArray() {
        int x = 0;
        int l = this.nodes.length;
        byte[] content = new byte[this.size() * l];
        for (byte[] d : this) {
            System.arraycopy(d, 0, content, x, l);
            x += l;
        }
        return content;
    }

    @Override
    public byte[] fillState(byte[] state, int index) {
        int l = this.getComponents().length;
        if (state == null || state.length != l) {
            state = new byte[l];
        }
        byte[] innerstate = (byte[])this.get(index);
        int ofset = innerstate.length;
        System.arraycopy(innerstate, 0, state, 0, ofset);
        if (this.isExtra && this.extra != null) {
            innerstate = this.extra.get(index);
            System.arraycopy(innerstate, 0, state, ofset, innerstate.length);
        }
        return state;
    }
}

