/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.fixpoints;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.NodeRelation;
import org.colomoto.mddlib.operators.AbstractFlexibleOperator;

class IsStableOperation
extends AbstractFlexibleOperator {
    private static List<IsStableOperation> OPERATIONS = new ArrayList<IsStableOperation>();
    private final int value;

    public static IsStableOperation getOp(int value) {
        if (value < 0) {
            return new IsStableOperation(value);
        }
        if (value >= OPERATIONS.size()) {
            for (int i = OPERATIONS.size(); i <= value; ++i) {
                OPERATIONS.add(new IsStableOperation(i));
            }
        }
        return OPERATIONS.get(value);
    }

    private IsStableOperation(int value) {
        super(AbstractFlexibleOperator.MergeAction.CUSTOM);
        this.setAction(NodeRelation.LN, AbstractFlexibleOperator.MergeAction.ASKME);
        this.setAction(NodeRelation.NL, AbstractFlexibleOperator.MergeAction.CUSTOM);
        this.value = value;
        this.lock();
    }

    public AbstractFlexibleOperator.MergeAction ask(MDDManager factory, NodeRelation type, int first, int other) {
        switch (type) {
            case LN: {
                if (first == 0) {
                    return AbstractFlexibleOperator.MergeAction.THIS;
                }
                return AbstractFlexibleOperator.MergeAction.RECURSIVE;
            }
        }
        System.err.println("DEBUG: isStable ask should not come here!");
        return null;
    }

    public int custom(MDDManager factory, NodeRelation type, int first, int other) {
        switch (type) {
            case LL: 
            case NL: {
                if (other == this.value) {
                    return factory.use(first);
                }
                return 0;
            }
        }
        System.err.println("DEBUG: isStable custom should not come here!");
        return -1;
    }

    static {
        for (int i = 0; i < 2; ++i) {
            OPERATIONS.add(new IsStableOperation(i));
        }
    }
}

