/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.fixpoints;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.mddlib.MDDManager;
import org.colomoto.mddlib.MDDVariable;

class NodeIterator
implements Iterator<Integer> {
    int nbgene;
    int nbremain;
    int bestIndex;
    int bestValue;
    boolean[][] t_reg;
    int[][] t_newreg;

    public NodeIterator(LogicalModel model) {
        this.buildAdjTable(model);
    }

    private void buildAdjTable(LogicalModel model) {
        List<NodeInfo> nodeOrder = model.getComponents();
        MDDManager ddmanager = model.getMDDManager();
        this.nbgene = this.nbremain = nodeOrder.size();
        this.t_newreg = new int[this.nbgene][2];
        this.t_reg = new boolean[this.nbgene][this.nbgene];
        this.bestValue = this.nbgene + 1;
        int[] functions = model.getLogicalFunctions();
        for (int i = 0; i < this.nbgene; ++i) {
            Collection<MDDVariable> regulators = NodeIterator.getRegulators(ddmanager, functions[i]);
            int cpt = 0;
            boolean[] t_regline = this.t_reg[i];
            for (MDDVariable var : regulators) {
                int r = ddmanager.getVariableIndex(var);
                t_regline[r] = true;
                ++cpt;
            }
            if (!this.t_reg[i][i]) {
                this.t_reg[i][i] = true;
            }
            this.t_newreg[i][0] = i;
            this.t_newreg[i][1] = ++cpt;
            if (cpt >= this.bestValue) continue;
            this.bestValue = cpt;
            this.bestIndex = i;
        }
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int choice = this.bestIndex;
        int ret = this.t_newreg[choice][0];
        this.bestValue = this.nbgene + 1;
        this.bestIndex = -1;
        if (choice != -1) {
            int i;
            this.t_newreg[choice] = this.t_newreg[--this.nbremain];
            boolean[] t_old = this.t_reg[choice];
            this.t_reg[choice] = this.t_reg[this.nbremain];
            for (i = 0; i < t_old.length; ++i) {
                if (!t_old[i]) continue;
                for (int j = 0; j < this.nbremain; ++j) {
                    if (!this.t_reg[j][i]) continue;
                    this.t_reg[j][i] = false;
                    int[] nArray = this.t_newreg[j];
                    nArray[1] = nArray[1] - 1;
                }
            }
            for (i = 0; i < this.nbremain; ++i) {
                if (this.t_newreg[i][1] >= this.bestValue) continue;
                this.bestValue = this.t_newreg[i][1];
                this.bestIndex = i;
            }
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.nbremain > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static Collection<MDDVariable> getRegulators(MDDManager factory, int f) {
        HashSet<MDDVariable> regulators = new HashSet<MDDVariable>();
        NodeIterator.addRegulators(regulators, factory, f);
        return regulators;
    }

    private static void addRegulators(Set<MDDVariable> regulators, MDDManager factory, int f) {
        if (factory.isleaf(f)) {
            return;
        }
        MDDVariable var = factory.getNodeVariable(f);
        regulators.add(var);
        for (int v = 0; v < var.nbval; ++v) {
            NodeIterator.addRegulators(regulators, factory, factory.getChild(f, v));
        }
    }
}

