/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.deterministic;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.BaseUpdater;
import org.colomoto.biolqm.tool.simulation.deterministic.DeterministicUpdater;
import org.colomoto.biolqm.tool.simulation.grouping.ModelGrouping;

public class DeterministicPriorityUpdater
extends BaseUpdater
implements DeterministicUpdater {
    int[][] blocks;

    public DeterministicPriorityUpdater(LogicalModel model, int[][] blocks) {
        super(model);
        this.blocks = blocks;
    }

    public DeterministicPriorityUpdater(LogicalModel model, String config) {
        this(new ModelGrouping(model, config));
    }

    public DeterministicPriorityUpdater(ModelGrouping mpc) {
        super(mpc.getModel());
        this.blocks = mpc.getDeterministicBlocks();
    }

    @Override
    public byte[] getSuccessor(byte[] state) {
        byte[] nextstate = null;
        for (int[] block : this.blocks) {
            for (int i = 0; i < block.length; i += 2) {
                int idx = block[i];
                int cst = block[i + 1];
                int change = this.nodeChange(state, idx);
                if (change == 0 || cst != 0 && cst != change) continue;
                nextstate = this.update(state, idx, change, nextstate);
            }
            if (nextstate != null) break;
        }
        return nextstate;
    }
}

