/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.deterministic;

import java.util.Iterator;
import java.util.List;
import org.colomoto.biolqm.NodeInfo;
import org.colomoto.biolqm.tool.simulation.deterministic.DeterministicUpdater;
import org.colomoto.biolqm.tool.simulation.deterministic.StateIterator;

public class DeterministicSimulation
implements Iterable<byte[]> {
    private final DeterministicUpdater updater;
    private final byte[] init;
    private final int max_steps;
    private final int length;

    public DeterministicSimulation(DeterministicUpdater updater, byte[] init) {
        this(updater, init, 10000);
    }

    public DeterministicSimulation(DeterministicUpdater updater, byte[] init, int max_steps) {
        this(updater, init, 100, max_steps);
    }

    public DeterministicSimulation(DeterministicUpdater updater, byte[] init, int length, int max_steps) {
        this.updater = updater;
        this.init = init;
        this.length = length;
        this.max_steps = max_steps;
    }

    public List<NodeInfo> getNodes() {
        return this.updater.getModel().getComponents();
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new StateIterator(this.init, this.updater, this.length, this.max_steps);
    }
}

