/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.deterministic;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.AbstractToolTask;
import org.colomoto.biolqm.tool.simulation.InitialStateFactory;
import org.colomoto.biolqm.tool.simulation.UpdaterFactory;
import org.colomoto.biolqm.tool.simulation.deterministic.DeterministicSimulation;
import org.colomoto.biolqm.tool.simulation.deterministic.DeterministicUpdater;

public class TraceTask
extends AbstractToolTask<DeterministicSimulation> {
    String updater_config = null;
    byte[] state = null;
    int max_steps = 1000;
    int length = 100;

    public TraceTask(LogicalModel model) {
        super(model);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameters(String[] parameters) {
        if (parameters == null) {
            return;
        }
        StringBuffer tmp = new StringBuffer();
        block6: for (int idx = 0; idx < parameters.length; ++idx) {
            String s = parameters[idx].trim();
            if (s == null || s.length() == 0) continue;
            String next = null;
            if (s.length() != 2 || s.charAt(0) != '-') throw new RuntimeException("Unrecognized parameter: " + s);
            while (++idx < parameters.length) {
                String snext = parameters[idx];
                if (snext.startsWith("-")) {
                    --idx;
                    break;
                }
                if (next == null) {
                    next = snext;
                    continue;
                }
                next = next + " " + snext;
            }
            switch (s.charAt(1)) {
                case 'u': {
                    this.updater_config = next;
                    continue block6;
                }
                case 'm': {
                    this.parseMax(next);
                    continue block6;
                }
                case 'l': {
                    this.parseLength(next);
                    continue block6;
                }
                case 'i': {
                    this.state = InitialStateFactory.parseInitialState(this.model, next);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unrecognized parameter: " + s);
                }
            }
        }
    }

    private void parseMax(String s) {
        this.max_steps = Integer.parseInt(s);
    }

    private void parseLength(String s) {
        this.length = Integer.parseInt(s);
    }

    public DeterministicSimulation getSimulation() {
        byte[] state = this.state;
        if (state == null) {
            state = new byte[this.model.getComponents().size()];
        }
        DeterministicUpdater updater = UpdaterFactory.getDeterministicUpdater(this.model, this.updater_config);
        return new DeterministicSimulation(updater, state, this.length, this.max_steps);
    }

    @Override
    protected DeterministicSimulation performTask() {
        return this.getSimulation();
    }

    @Override
    public void cli() {
        DeterministicSimulation simulation = this.getSimulation();
        byte[] extra = null;
        int n_extra = this.model.getExtraComponents().size();
        if (n_extra > 0) {
            extra = new byte[n_extra];
        }
        for (byte[] state : simulation) {
            for (byte b : state) {
                System.out.print(b);
            }
            if (extra != null) {
                this.model.fillExtraValues(state, extra);
                System.out.print("  ");
                for (byte b : extra) {
                    System.out.print(b);
                }
            }
            System.out.println();
        }
    }
}

