/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.multiplesuccessor;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.AbstractMultipleSuccessorUpdater;

public class AsynchronousUpdater
extends AbstractMultipleSuccessorUpdater {
    private final int[] changes;

    public AsynchronousUpdater(LogicalModel model) {
        super(model);
        this.changes = new int[this.size];
    }

    @Override
    public List<byte[]> getSuccessors(byte[] state) {
        int nb_changes = 0;
        for (int idx = 0; idx < this.size; ++idx) {
            int change;
            this.changes[idx] = change = this.nodeChange(state, idx);
            if (change == 0) continue;
            ++nb_changes;
        }
        if (nb_changes == 0) {
            return AsynchronousUpdater.getEmptySuccessors();
        }
        ArrayList<byte[]> successors = new ArrayList<byte[]>(nb_changes);
        for (int idx = 0; idx < this.size; ++idx) {
            int change = this.changes[idx];
            if (change == 0) continue;
            successors.add(this.update(state, idx, change, null));
        }
        return successors;
    }
}

