/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.multiplesuccessor;

import java.util.ArrayList;
import java.util.List;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.AbstractMultipleSuccessorUpdater;

public class CompleteUpdater
extends AbstractMultipleSuccessorUpdater {
    private final int[] changes;
    private final int[] changing;

    public CompleteUpdater(LogicalModel model) {
        super(model);
        this.changes = new int[this.size];
        this.changing = new int[this.size];
    }

    @Override
    public List<byte[]> getSuccessors(byte[] state) {
        int nb_changes = 0;
        for (int idx = 0; idx < this.size; ++idx) {
            int change;
            this.changes[idx] = change = this.nodeChange(state, idx);
            if (change == 0) continue;
            this.changing[nb_changes] = idx;
            ++nb_changes;
        }
        if (nb_changes == 0) {
            return CompleteUpdater.getEmptySuccessors();
        }
        if (nb_changes > 30) {
            throw new RuntimeException("Too many successors in complete simulation");
        }
        int nb_successors = (int)Math.pow(2.0, nb_changes) - 1;
        ArrayList<byte[]> successors = new ArrayList<byte[]>(nb_successors);
        for (int cur = 0; cur < nb_changes; ++cur) {
            this.fillSuccessors(state, cur, nb_changes, successors);
        }
        return successors;
    }

    private void fillSuccessors(byte[] state, int current, int count, List<byte[]> successors) {
        if (current >= count) {
            return;
        }
        int idx = this.changing[current];
        int change = this.changes[idx];
        if (change == 0) {
            return;
        }
        byte[] seed = this.update(state, idx, change, null);
        successors.add(seed);
        for (int c = current + 1; c < count; ++c) {
            this.fillSuccessors(seed, c, count, successors);
        }
    }
}

