/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.multiplesuccessor;

import java.util.Iterator;
import java.util.LinkedList;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.MultipleSuccessorsUpdater;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.QueuedState;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.SimulationStrategy;

public abstract class MultipleSuccessorSimulation {
    private final LinkedList<QueuedState> queue;
    private final MultipleSuccessorsUpdater updater;
    private final SimulationStrategy strategy;
    private int max_depth = -1;
    private int current_depth = 0;

    public MultipleSuccessorSimulation(MultipleSuccessorsUpdater updater) {
        this(updater, SimulationStrategy.DEPTH_FIRST);
    }

    public MultipleSuccessorSimulation(MultipleSuccessorsUpdater updater, SimulationStrategy strategy) {
        this.updater = updater;
        this.strategy = strategy;
        this.queue = new LinkedList();
    }

    public void runSimulation(Iterator<byte[]> initialStates) {
        while (initialStates.hasNext()) {
            this.addState(initialStates.next());
            this.runSimulation();
        }
    }

    public void runSimulation() {
        while (!this.queue.isEmpty()) {
            QueuedState queued = this.strategy == SimulationStrategy.BREADTH_FIRST ? this.queue.removeFirst() : this.queue.removeLast();
            byte[] state = queued.state;
            this.current_depth = queued.depth + 1;
            if (this.max_depth > 0 && this.current_depth > this.max_depth) continue;
            for (byte[] child : this.updater.getSuccessors(state)) {
                this.addState(child);
                this.addTransition(state, child);
            }
        }
    }

    protected void enqueue(byte[] state) {
        this.queue.addLast(new QueuedState(state, this.current_depth));
    }

    public abstract void addState(byte[] var1);

    public abstract void addTransition(byte[] var1, byte[] var2);
}

