/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.random;

import java.util.List;
import java.util.Random;
import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.simulation.multiplesuccessor.MultipleSuccessorsUpdater;
import org.colomoto.biolqm.tool.simulation.random.RandomUpdater;

public class RandomUpdaterWrapper
implements RandomUpdater {
    private final MultipleSuccessorsUpdater updater;
    private final Random random = new Random();

    public RandomUpdaterWrapper(MultipleSuccessorsUpdater updater) {
        this.updater = updater;
    }

    @Override
    public byte[] pickSuccessor(byte[] state) {
        List<byte[]> successors = this.updater.getSuccessors(state);
        if (successors == null || successors.size() == 0) {
            return null;
        }
        int l = successors.size();
        if (l == 1) {
            return successors.get(0);
        }
        return successors.get(this.random.nextInt(l));
    }

    @Override
    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public LogicalModel getModel() {
        return this.updater.getModel();
    }
}

