/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.random;

import org.colomoto.biolqm.LogicalModel;
import org.colomoto.biolqm.tool.AbstractToolTask;
import org.colomoto.biolqm.tool.simulation.InitialStateFactory;
import org.colomoto.biolqm.tool.simulation.UpdaterFactory;
import org.colomoto.biolqm.tool.simulation.random.RandomUpdater;
import org.colomoto.biolqm.tool.simulation.random.RandomWalkSimulation;

public class RandomWalkTask
extends AbstractToolTask<RandomWalkSimulation> {
    String updater_config = null;
    byte[] state = null;
    int max_steps = 1000;
    int seed = -1;

    public RandomWalkTask(LogicalModel model) {
        super(model);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameters(String[] parameters) {
        if (parameters == null || parameters.length < 1) {
            return;
        }
        StringBuffer tmp = new StringBuffer();
        block6: for (int idx = 0; idx < parameters.length; ++idx) {
            String s = parameters[idx].trim();
            if (s == null || s.length() < 1) continue;
            String next = null;
            if (s.length() != 2 || s.charAt(0) != '-') throw new RuntimeException("Unrecognized parameter: " + s);
            while (++idx < parameters.length) {
                String snext = parameters[idx];
                if (snext.startsWith("-")) {
                    --idx;
                    break;
                }
                if (next == null) {
                    next = snext;
                    continue;
                }
                next = next + " " + snext;
            }
            switch (s.charAt(1)) {
                case 'u': {
                    this.updater_config = next;
                    continue block6;
                }
                case 'm': {
                    this.parseMax(next);
                    continue block6;
                }
                case 's': {
                    this.parseSeed(next);
                    continue block6;
                }
                case 'i': {
                    this.state = InitialStateFactory.parseInitialState(this.model, next);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unrecognized parameter: " + s);
                }
            }
        }
    }

    public void parseMax(String s) {
        this.max_steps = Integer.parseInt(s);
    }

    public void parseSeed(String s) {
        this.seed = Integer.parseInt(s);
    }

    public RandomWalkSimulation getSimulation() {
        byte[] state = this.state;
        if (state == null) {
            state = new byte[this.model.getComponents().size()];
        }
        RandomUpdater updater = UpdaterFactory.getRandomUpdater(this.model, this.updater_config);
        if (this.seed >= 0) {
            updater.setSeed(this.seed);
        }
        return new RandomWalkSimulation(updater, state, this.max_steps);
    }

    @Override
    protected RandomWalkSimulation performTask() {
        return this.getSimulation();
    }

    @Override
    public void cli() {
        RandomWalkSimulation simulation = this.getSimulation();
        for (byte[] state : simulation) {
            for (byte b : state) {
                System.out.print(b);
            }
            System.out.println();
        }
    }
}

