/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.tool.simulation.random;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.colomoto.biolqm.tool.simulation.random.RandomUpdater;

class StateIterator
implements Iterator<byte[]> {
    private byte[] state;
    private final RandomUpdater updater;
    private int steps;

    public StateIterator(byte[] state, RandomUpdater updater, int max_steps) {
        this.state = state;
        this.updater = updater;
        this.steps = max_steps;
    }

    @Override
    public boolean hasNext() {
        return this.state != null;
    }

    @Override
    public byte[] next() {
        if (this.state == null) {
            throw new NoSuchElementException();
        }
        byte[] ret = this.state;
        this.state = (byte[])(this.steps < 1 ? null : this.updater.pickSuccessor(this.state));
        --this.steps;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

