/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.biolqm.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.colomoto.biolqm.tool.simulation.grouping.ModelGrouping;
import org.colomoto.biolqm.widgets.PanelChangedEventListener;

public class PriorityClassPanel
extends JPanel {
    private static final long serialVersionUID = -6249588129185682333L;
    private final int GROUP_WIDTH = 90;
    private final int CLASS_SPACING = 15;
    private boolean guiMultipSuc;
    private List<List<JList<String>>> guiClasses;
    private ModelGrouping mpc;
    private JPanel jpCenter;
    private JButton jbIncClass;
    private JButton jbDecClass;
    private JButton jbIncGroup;
    private JButton jbDecGroup;

    private JButton getNoMargins(String text) {
        JButton jb = new JButton(text);
        jb.setMargin(new Insets(0, 0, 0, 0));
        return jb;
    }

    public PriorityClassPanel(ModelGrouping mpc, boolean guiMultipSuc) {
        this.mpc = mpc;
        this.guiMultipSuc = guiMultipSuc;
        this.setLayout(new BorderLayout());
        this.guiClasses = new ArrayList<List<JList<String>>>();
        this.jbIncClass = this.getNoMargins("\u2190");
        this.jbDecClass = this.getNoMargins("\u2192");
        this.jbIncGroup = this.getNoMargins("\u2191");
        this.jbDecGroup = this.getNoMargins("\u2193");
        JPanel jpTopCenter = new JPanel(new BorderLayout());
        this.jpCenter = new JPanel(new GridBagLayout());
        jpTopCenter.add((Component)this.jpCenter, "Center");
        this.add((Component)jpTopCenter, "Center");
        JPanel jpSouthCenter = new JPanel(new FlowLayout());
        JButton jbSplit = this.getNoMargins("Split");
        jbSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriorityClassPanel.this.splitSelVars();
                PriorityClassPanel.this.updateGUI();
            }
        });
        jpSouthCenter.add(jbSplit);
        JButton jbUnsplit = this.getNoMargins("Unsplit");
        jbUnsplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriorityClassPanel.this.unsplitSelVars();
                PriorityClassPanel.this.updateGUI();
            }
        });
        jpSouthCenter.add(jbUnsplit);
        this.jbIncClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriorityClassPanel.this.incPriorityOfSelVars();
                PriorityClassPanel.this.updateGUI();
            }
        });
        jpSouthCenter.add(this.jbIncClass);
        if (this.guiMultipSuc) {
            this.jbIncGroup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PriorityClassPanel.this.incGroupOfSelVars();
                    PriorityClassPanel.this.updateGUI();
                }
            });
            jpSouthCenter.add(this.jbIncGroup);
            this.jbDecGroup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PriorityClassPanel.this.decGroupOfSelVars();
                    PriorityClassPanel.this.updateGUI();
                }
            });
            jpSouthCenter.add(this.jbDecGroup);
        }
        this.jbDecClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriorityClassPanel.this.decPriorityOfSelVars();
                PriorityClassPanel.this.updateGUI();
            }
        });
        jpSouthCenter.add(this.jbDecClass);
        JButton jbSingle = this.getNoMargins("Collapse All");
        jbSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriorityClassPanel.this.collapseAll();
                PriorityClassPanel.this.updateGUI();
            }
        });
        jpSouthCenter.add(jbSingle);
        this.add((Component)jpSouthCenter, "South");
        jpSouthCenter.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    public void updatePriorityList() {
        this.guiClasses.clear();
        this.jpCenter.removeAll();
        GridBagConstraints gdcCenter = new GridBagConstraints();
        gdcCenter.anchor = 23;
        gdcCenter.gridx = 0;
        gdcCenter.gridy = 0;
        for (int idxPC = 0; idxPC < this.mpc.size(); ++idxPC) {
            this.guiClasses.add(new ArrayList());
            JPanel jpPClass = new JPanel(new BorderLayout());
            jpPClass.setAlignmentY(0.0f);
            JPanel jpPClassHeader = new JPanel(new BorderLayout());
            jpPClass.add((Component)jpPClassHeader, "North");
            JLabel jlTmp = new JLabel("   Rank " + (idxPC + 1) + "   ", 0);
            jlTmp.setToolTipText(idxPC == 0 ? "Fastest class" : (idxPC == this.mpc.size() - 1 ? "Slowest class" : ""));
            jpPClassHeader.add((Component)jlTmp, "Center");
            JButton jbInc = this.getNoMargins("\u2190");
            jbInc.setActionCommand("" + idxPC);
            jbInc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton jb = (JButton)e.getSource();
                    int pos = Integer.parseInt(jb.getActionCommand());
                    PriorityClassPanel.this.mpc.switchClasses(pos, pos - 1);
                    PriorityClassPanel.this.fireActionEvent();
                    PriorityClassPanel.this.updatePriorityList();
                }
            });
            jpPClassHeader.add((Component)jbInc, "Before");
            if (idxPC == 0) {
                jbInc.setEnabled(false);
            }
            JButton jbDec = this.getNoMargins("\u2192");
            jbDec.setActionCommand("" + idxPC);
            jbDec.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton jb = (JButton)e.getSource();
                    int pos = Integer.parseInt(jb.getActionCommand());
                    PriorityClassPanel.this.mpc.switchClasses(pos, pos + 1);
                    PriorityClassPanel.this.fireActionEvent();
                    PriorityClassPanel.this.updatePriorityList();
                }
            });
            jpPClassHeader.add((Component)jbDec, "After");
            if (idxPC + 1 == this.mpc.size()) {
                jbDec.setEnabled(false);
            }
            JPanel jpGroups = new JPanel(new GridBagLayout());
            GridBagConstraints gbcG = new GridBagConstraints();
            gbcG.insets = new Insets(3, 3, 3, 3);
            gbcG.gridx = 0;
            List<List<String>> lGrpVars = this.mpc.getClassVars(idxPC);
            int g = 0;
            while (g < lGrpVars.size()) {
                List<String> vars = lGrpVars.get(g);
                DefaultListModel<String> lModel = new DefaultListModel<String>();
                Collections.sort(vars, String.CASE_INSENSITIVE_ORDER);
                for (String var : vars) {
                    lModel.addElement(var);
                }
                JList jList = new JList(lModel);
                jList.setBorder(BorderFactory.createLoweredBevelBorder());
                jList.setFixedCellWidth(this.GROUP_WIDTH);
                jList.setSelectionMode(2);
                jList.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        JList selJList = (JList)e.getSource();
                        for (List lClass : PriorityClassPanel.this.guiClasses) {
                            for (JList lGroup : lClass) {
                                if (lGroup.equals(selJList)) continue;
                                lGroup.clearSelection();
                            }
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }
                });
                jList.addMouseMotionListener(new MouseMotionListener(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        JList l = (JList)e.getSource();
                        DefaultListModel m = (DefaultListModel)l.getModel();
                        int index = l.locationToIndex(e.getPoint());
                        if (index > -1) {
                            l.setToolTipText(((String)m.getElementAt(index)).toString());
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                    }
                });
                this.guiClasses.get(idxPC).add(jList);
                gbcG.gridy = g++;
                jpGroups.add(jList, gbcG);
            }
            JScrollPane jScroll = new JScrollPane(jpGroups);
            jScroll.setVerticalScrollBarPolicy(22);
            jpPClass.add((Component)jScroll, "Center");
            if (this.guiMultipSuc) {
                JPanel jpTmp = new JPanel(new BorderLayout());
                jpTmp.add((Component)new JLabel("Groups", 0), "Center");
                JButton jbExpand = this.getNoMargins("E");
                jbExpand.setToolTipText("Expand - one component per group (Asynchronous)");
                jbExpand.setActionCommand("" + idxPC);
                jbExpand.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton jb = (JButton)e.getSource();
                        int pos = Integer.parseInt(jb.getActionCommand());
                        PriorityClassPanel.this.mpc.groupExpand(pos);
                        PriorityClassPanel.this.fireActionEvent();
                        PriorityClassPanel.this.updatePriorityList();
                    }
                });
                jpTmp.add((Component)jbExpand, "Before");
                JButton jbCollapse = this.getNoMargins("C");
                jbCollapse.setToolTipText("Collapse - All components in single group (Synchronous)");
                jbCollapse.setActionCommand("" + idxPC);
                jbCollapse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton jb = (JButton)e.getSource();
                        int pos = Integer.parseInt(jb.getActionCommand());
                        PriorityClassPanel.this.mpc.groupCollapse(pos);
                        PriorityClassPanel.this.fireActionEvent();
                        PriorityClassPanel.this.updatePriorityList();
                    }
                });
                jpTmp.add((Component)jbCollapse, "After");
                jpPClass.add((Component)jpTmp, "South");
            }
            jpPClass.setMinimumSize(new Dimension(90, 450));
            this.jpCenter.add((Component)jpPClass, gdcCenter);
            ++gdcCenter.gridx;
            this.jpCenter.add(Box.createRigidArea(new Dimension(this.CLASS_SPACING, 10)), gdcCenter);
            ++gdcCenter.gridx;
        }
        this.updateGUI();
    }

    private void splitSelVars() {
        block0: for (int i = 0; i < this.guiClasses.size(); ++i) {
            for (int g = 0; g < this.guiClasses.get(i).size(); ++g) {
                List<String> values = this.guiClasses.get(i).get(g).getSelectedValuesList();
                if (values.isEmpty()) continue;
                for (String var : values) {
                    this.mpc.split(i, g, var);
                }
                this.fireActionEvent();
                break block0;
            }
        }
        this.updatePriorityList();
    }

    private void unsplitSelVars() {
        block0: for (int i = 0; i < this.guiClasses.size(); ++i) {
            for (int g = 0; g < this.guiClasses.get(i).size(); ++g) {
                List<String> values = this.guiClasses.get(i).get(g).getSelectedValuesList();
                if (values.isEmpty()) continue;
                for (String var : values) {
                    this.mpc.unsplit(i, g, var);
                }
                this.fireActionEvent();
                break block0;
            }
        }
        this.updatePriorityList();
    }

    private void incPriorityOfSelVars() {
        block0: for (int i = 0; i < this.guiClasses.size(); ++i) {
            for (int g = 0; g < this.guiClasses.get(i).size(); ++g) {
                List<String> values = this.guiClasses.get(i).get(g).getSelectedValuesList();
                if (values.isEmpty()) continue;
                this.mpc.incPriorities(i, g, values);
                this.fireActionEvent();
                break block0;
            }
        }
        this.updatePriorityList();
    }

    private void decPriorityOfSelVars() {
        block0: for (int i = 0; i < this.guiClasses.size(); ++i) {
            for (int g = 0; g < this.guiClasses.get(i).size(); ++g) {
                List<String> values = this.guiClasses.get(i).get(g).getSelectedValuesList();
                if (values.isEmpty()) continue;
                this.mpc.decPriorities(i, g, values);
                this.fireActionEvent();
                break block0;
            }
        }
        this.updatePriorityList();
    }

    private void incGroupOfSelVars() {
        block0: for (int i = 0; i < this.guiClasses.size(); ++i) {
            for (int g = 0; g < this.guiClasses.get(i).size(); ++g) {
                List<String> values = this.guiClasses.get(i).get(g).getSelectedValuesList();
                if (values.isEmpty()) continue;
                this.mpc.incGroup(i, g, values);
                this.fireActionEvent();
                break block0;
            }
        }
        this.updatePriorityList();
    }

    private void decGroupOfSelVars() {
        block0: for (int i = 0; i < this.guiClasses.size(); ++i) {
            for (int g = 0; g < this.guiClasses.get(i).size(); ++g) {
                List<String> values = this.guiClasses.get(i).get(g).getSelectedValuesList();
                if (values.isEmpty()) continue;
                this.mpc.decGroup(i, g, values);
                this.fireActionEvent();
                break block0;
            }
        }
        this.updatePriorityList();
    }

    private void collapseAll() {
        this.mpc.collapseAll();
        this.fireActionEvent();
        this.updatePriorityList();
    }

    private void updateGUI() {
        this.jpCenter.revalidate();
        this.jpCenter.repaint();
    }

    public void addActionListener(PanelChangedEventListener listener) {
        this.listenerList.add(PanelChangedEventListener.class, listener);
    }

    public void removeActionListener(PanelChangedEventListener listener) {
        this.listenerList.remove(PanelChangedEventListener.class, listener);
    }

    private void fireActionEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != PanelChangedEventListener.class) continue;
            ((PanelChangedEventListener)listeners[i + 1]).panelChangedOccurred();
        }
    }
}

