/*
 * Decompiled with CFR 0.152.
 */
package org.colomoto.common.task;

import org.colomoto.common.task.Task;
import org.colomoto.common.task.TaskListener;
import org.colomoto.common.task.TaskStatus;

public abstract class AbstractTask<T>
extends Thread
implements Task<T> {
    protected boolean canceled = false;
    private TaskListener listener = null;
    private TaskStatus status = TaskStatus.STOPPED;
    private T result = null;

    protected abstract T performTask() throws Exception;

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public TaskStatus getStatus() {
        return this.status;
    }

    @Override
    public synchronized T call() throws Exception {
        if (this.status == TaskStatus.RUNNING) {
            throw new RuntimeException("Should not be able to call a running task");
        }
        this.result = null;
        this.canceled = false;
        this.status = TaskStatus.RUNNING;
        this.result = this.performTask();
        if (this.canceled) {
            this.result = null;
            this.status = TaskStatus.CANCELED;
        } else {
            this.status = TaskStatus.FINISHED;
        }
        return this.result;
    }

    @Override
    public void cancel() {
        if (this.status == TaskStatus.RUNNING) {
            this.canceled = true;
        }
    }

    @Override
    public void background(TaskListener listener) {
        this.listener = listener;
        this.start();
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            this.status = TaskStatus.ERROR;
        }
        if (this.listener != null) {
            this.listener.taskUpdated(this);
        }
    }
}

