/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.ident.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.atlas.maven.ident.jackson.ProjectRefDeserializer;
import org.commonjava.atlas.maven.ident.jackson.ProjectRefKeyDeserializer;
import org.commonjava.atlas.maven.ident.jackson.ProjectRefSerializer;
import org.commonjava.atlas.maven.ident.ref.ArtifactRef;
import org.commonjava.atlas.maven.ident.ref.ProjectRef;
import org.commonjava.atlas.maven.ident.ref.ProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleArtifactRef;
import org.commonjava.atlas.maven.ident.ref.SimpleProjectRef;
import org.commonjava.atlas.maven.ident.ref.SimpleProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleVersionlessArtifactRef;
import org.commonjava.atlas.maven.ident.ref.VersionlessArtifactRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectVersionRefSerializerModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends ProjectRef>> REF_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(ProjectRef.class, ProjectVersionRef.class, ArtifactRef.class, VersionlessArtifactRef.class, SimpleProjectRef.class, SimpleProjectVersionRef.class, SimpleArtifactRef.class, SimpleVersionlessArtifactRef.class)));
    public static final ProjectVersionRefSerializerModule INSTANCE = new ProjectVersionRefSerializerModule();

    public ProjectVersionRefSerializerModule() {
        super("ProjectRef (with variants) Serializer");
        for (Class<? extends ProjectRef> cls : REF_CLASSES) {
            this.register(cls);
        }
    }

    private <T extends ProjectRef> void register(Class<T> cls) {
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        logger.debug("Registering {} serializers/deserialers", (Object)cls.getSimpleName());
        this.addSerializer(cls, (JsonSerializer)new ProjectRefSerializer<T>(cls, false));
        this.addKeySerializer(cls, (JsonSerializer)new ProjectRefSerializer<T>(cls, true));
        this.addDeserializer(cls, (JsonDeserializer)new ProjectRefDeserializer<T>(cls));
        this.addKeyDeserializer(cls, new ProjectRefKeyDeserializer<T>(cls));
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().getSimpleName().hashCode() + 17;
    }

    public boolean equals(Object other) {
        return ((Object)((Object)this)).getClass().equals(other.getClass());
    }
}

