/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.ident.ref;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.commonjava.atlas.maven.ident.ref.ArtifactRef;
import org.commonjava.atlas.maven.ident.ref.InvalidRefException;
import org.commonjava.atlas.maven.ident.ref.ProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleTypeAndClassifier;
import org.commonjava.atlas.maven.ident.ref.TypeAndClassifier;
import org.commonjava.atlas.maven.ident.version.InvalidVersionSpecificationException;
import org.commonjava.atlas.maven.ident.version.SingleVersion;
import org.commonjava.atlas.maven.ident.version.VersionSpec;

public class SimpleArtifactRef
extends SimpleProjectVersionRef
implements Serializable,
ArtifactRef {
    private static final long serialVersionUID = 1L;
    private final TypeAndClassifier tc;

    public SimpleArtifactRef(String groupId, String artifactId, VersionSpec version, String type, String classifier) {
        super(groupId, artifactId, version);
        this.tc = new SimpleTypeAndClassifier(type, classifier);
    }

    public SimpleArtifactRef(ProjectVersionRef ref, String type, String classifier) {
        super(ref.getGroupId(), ref.getArtifactId(), ref.getVersionSpecRaw(), ref.getVersionStringRaw());
        this.tc = new SimpleTypeAndClassifier(type, classifier);
    }

    public SimpleArtifactRef(ProjectVersionRef ref, TypeAndClassifier tc) {
        super(ref.getGroupId(), ref.getArtifactId(), ref.getVersionSpecRaw(), ref.getVersionStringRaw());
        this.tc = this.getSimpleTypeAndClassifier(tc);
    }

    public SimpleArtifactRef(String groupId, String artifactId, String versionSpec, String type, String classifier) throws InvalidVersionSpecificationException {
        super(groupId, artifactId, versionSpec);
        this.tc = new SimpleTypeAndClassifier(type, classifier);
    }

    public <T extends ArtifactRef> SimpleArtifactRef(ArtifactRef ref) {
        super(ref);
        this.tc = this.getSimpleTypeAndClassifier(ref.getTypeAndClassifier());
    }

    private SimpleTypeAndClassifier getSimpleTypeAndClassifier(TypeAndClassifier tc) {
        if (tc instanceof SimpleTypeAndClassifier) {
            return (SimpleTypeAndClassifier)tc;
        }
        return new SimpleTypeAndClassifier(tc.getType(), tc.getClassifier());
    }

    @Override
    public String toString() {
        return String.format("%s:%s:%s:%s%s", this.getGroupId(), this.getArtifactId(), this.getType(), this.getVersionString(), this.getClassifier() == null ? "" : ":" + this.getClassifier());
    }

    public static SimpleArtifactRef parse(String spec) {
        String[] parts = spec.split(":");
        if (parts.length < 3 || StringUtils.isEmpty((CharSequence)parts[0]) || StringUtils.isEmpty((CharSequence)parts[1]) || StringUtils.isEmpty((CharSequence)parts[2])) {
            throw new InvalidRefException("SimpleArtifactRef must contain AT LEAST non-empty groupId, artifactId, AND version. (Given: '" + spec + "')", new Object[0]);
        }
        String g = parts[0];
        String a = parts[1];
        String v = parts[2];
        String t = "pom";
        String c = null;
        if (parts.length > 3) {
            t = v;
            v = parts[3];
            if (parts.length > 4) {
                c = parts[4];
            }
        }
        return new SimpleArtifactRef(g, a, v, t, c);
    }

    @Override
    public SimpleArtifactRef newRef(String groupId, String artifactId, SingleVersion version) {
        return new SimpleArtifactRef(groupId, artifactId, version, this.tc.getType(), this.tc.getClassifier());
    }

    @Override
    public String getType() {
        return this.tc.getType();
    }

    @Override
    public String getClassifier() {
        return this.tc.getClassifier();
    }

    @Override
    public TypeAndClassifier getTypeAndClassifier() {
        return this.tc;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tc == null ? 0 : this.tc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ArtifactRef)) {
            return false;
        }
        ArtifactRef other = (ArtifactRef)obj;
        return this.artifactFieldsEqual(other);
    }

    private boolean artifactFieldsEqual(ArtifactRef other) {
        return !(this.tc == null ? other.getTypeAndClassifier() != null : !this.tc.equals(other.getTypeAndClassifier()));
    }

    @Override
    public boolean versionlessEquals(ProjectVersionRef other) {
        if (!super.versionlessEquals(other)) {
            return false;
        }
        if (!(other instanceof ArtifactRef)) {
            return this.artifactFieldsEqual(new SimpleArtifactRef(other, "pom", null));
        }
        return this.artifactFieldsEqual((ArtifactRef)other);
    }
}

