/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.ident.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonjava.atlas.maven.ident.ref.ArtifactRef;
import org.commonjava.atlas.maven.ident.ref.ProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleArtifactRef;
import org.commonjava.atlas.maven.ident.ref.SimpleProjectVersionRef;
import org.commonjava.atlas.maven.ident.util.PathInfo;
import org.commonjava.atlas.maven.ident.util.SnapshotUtils;
import org.commonjava.atlas.maven.ident.version.part.SnapshotPart;

public class ArtifactPathInfo
implements PathInfo {
    private static final String GROUP_REGEX = "(([^/]+/)*[^/]+)";
    private static final String ARTIFACT_REGEX = "([^/]+)";
    private static final String VERSION_RAW_REGEX = "(([^/]+)(-SNAPSHOT)?)";
    private static final String CLASSIFIER_AND_TYPE = "-?(.+)";
    private static final String ARTIFACT_PATH_REGEX = "/?(([^/]+/)*[^/]+)/([^/]+)/(([^/]+)(-SNAPSHOT)?)/(\\3-((\\4)|(\\5-([0-9]{8}.[0-9]{6})-([0-9]+)))-?(.+))";
    private static final int GROUP_ID_GROUP = 1;
    private static final int ARTIFACT_ID_GROUP = 3;
    private static final int VERSION_RAW_GROUP = 4;
    private static final int FILE_GROUP = 7;
    private static final int VERSION_GROUP = 8;
    private static final String TAR_GZ = "tar.gz";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String type;
    private final String file;
    private final String fullPath;
    private final boolean isSnapshot;
    private final String releaseVersion;

    public static ArtifactPathInfo parse(String path) {
        if (path == null || path.length() < 1) {
            return null;
        }
        Matcher matcher = Pattern.compile(ARTIFACT_PATH_REGEX).matcher(path.replace('\\', '/'));
        if (!matcher.matches()) {
            return null;
        }
        int groupCount = matcher.groupCount();
        String g = matcher.group(1).replace('/', '.');
        String a = matcher.group(3);
        String v = matcher.group(8);
        String c = "";
        String left = matcher.group(groupCount);
        String t = left.endsWith(TAR_GZ) ? TAR_GZ : left.substring(left.lastIndexOf(".") + 1);
        int extLen = t.length() + 1;
        int leftLen = left.length();
        if (leftLen > extLen) {
            c = left.substring(0, leftLen - extLen);
        }
        String f = matcher.group(7);
        return new ArtifactPathInfo(g, a, v, c, t, f, path);
    }

    public ArtifactPathInfo(String groupId, String artifactId, String version, String file, String fullPath) {
        this(groupId, artifactId, version, null, "jar", file, fullPath);
    }

    public ArtifactPathInfo(String groupId, String artifactId, String version, String classifier, String type, String file, String fullPath) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type;
        this.file = file;
        this.fullPath = fullPath;
        this.isSnapshot = SnapshotUtils.isSnapshotVersion(version);
        this.releaseVersion = this.calcReleaseVersion(version);
    }

    private String calcReleaseVersion(String version) {
        int index = version.indexOf("-");
        if (index > 0) {
            return version.substring(0, index);
        }
        return version;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public synchronized SnapshotPart getSnapshotInfo() {
        return SnapshotUtils.extractSnapshotVersionPart(this.version);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public String toString() {
        return String.format("ArtifactPathInfo [groupId=%s, artifactId=%s, version=%s, file=%s]", this.groupId, this.artifactId, this.version, this.file);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactPathInfo other = (ArtifactPathInfo)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public ProjectVersionRef getProjectId() {
        return new SimpleProjectVersionRef(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    public ArtifactRef getArtifact() {
        return new SimpleArtifactRef(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getClassifier());
    }
}

