/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.ident.version;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.commonjava.atlas.maven.ident.version.CompoundVersionSpec;
import org.commonjava.atlas.maven.ident.version.InvalidVersionSpecificationException;
import org.commonjava.atlas.maven.ident.version.RangeVersionSpec;
import org.commonjava.atlas.maven.ident.version.SingleVersion;
import org.commonjava.atlas.maven.ident.version.VersionSpec;
import org.commonjava.atlas.maven.ident.version.part.NumericPart;
import org.commonjava.atlas.maven.ident.version.part.SeparatorPart;
import org.commonjava.atlas.maven.ident.version.part.VersionPart;
import org.commonjava.atlas.maven.ident.version.part.VersionPhrase;

public final class VersionSpecComparisons {
    private VersionSpecComparisons() {
    }

    public static Comparator<VersionSpec> comparator() {
        return new Comparator<VersionSpec>(){

            @Override
            public int compare(VersionSpec o1, VersionSpec o2) {
                return VersionSpecComparisons.compareTo(o1, o2);
            }
        };
    }

    public static int compareTo(VersionSpec first, VersionSpec second) {
        if (first instanceof SingleVersion) {
            return VersionSpecComparisons.compareSingleToSpec((SingleVersion)first, second);
        }
        if (first instanceof RangeVersionSpec) {
            return VersionSpecComparisons.compareRangeToSpec((RangeVersionSpec)first, second);
        }
        return VersionSpecComparisons.compareCompoundToSpec((CompoundVersionSpec)first, second);
    }

    private static int compareCompoundToSpec(CompoundVersionSpec first, VersionSpec second) {
        if (second instanceof SingleVersion) {
            return -1 * VersionSpecComparisons.compareSingleToCompound((SingleVersion)second, first);
        }
        if (second instanceof RangeVersionSpec) {
            return -1 * VersionSpecComparisons.compareRangeToCompound((RangeVersionSpec)second, first);
        }
        return VersionSpecComparisons.compareCompoundToCompound(first, (CompoundVersionSpec)second);
    }

    private static int compareRangeToSpec(RangeVersionSpec first, VersionSpec second) {
        if (second instanceof SingleVersion) {
            return -1 * VersionSpecComparisons.compareSingleToRange((SingleVersion)second, first);
        }
        if (second instanceof RangeVersionSpec) {
            return VersionSpecComparisons.compareRangeToRange(first, (RangeVersionSpec)second);
        }
        return VersionSpecComparisons.compareRangeToCompound(first, (CompoundVersionSpec)second);
    }

    private static int compareSingleToSpec(SingleVersion first, VersionSpec second) {
        if (second instanceof SingleVersion) {
            return VersionSpecComparisons.compareSingleToSingle(first, (SingleVersion)second);
        }
        if (second instanceof RangeVersionSpec) {
            return VersionSpecComparisons.compareSingleToRange(first, (RangeVersionSpec)second);
        }
        return VersionSpecComparisons.compareSingleToCompound(first, (CompoundVersionSpec)second);
    }

    private static int compareCompoundToCompound(CompoundVersionSpec first, CompoundVersionSpec second) {
        VersionSpec sl;
        VersionSpec fl;
        int lc;
        VersionSpec sf;
        VersionSpec ff = first.getFirstComponent();
        int fc = VersionSpecComparisons.compareTo(ff, sf = second.getFirstComponent());
        int comp = fc + (lc = VersionSpecComparisons.compareTo(fl = first.getLastComponent(), sl = second.getLastComponent()));
        if (comp == 0) {
            return 0;
        }
        if (comp < 0) {
            return -1;
        }
        return 1;
    }

    private static int compareRangeToCompound(RangeVersionSpec first, CompoundVersionSpec second) {
        int lc;
        int fc = VersionSpecComparisons.compareTo(first, second.getFirstComponent());
        int comp = fc + (lc = VersionSpecComparisons.compareTo(first, second.getLastComponent()));
        if (comp == 0) {
            return 0;
        }
        if (comp < 0) {
            return -1;
        }
        return 1;
    }

    private static int compareSingleToCompound(SingleVersion first, CompoundVersionSpec second) {
        int lc;
        int fc = VersionSpecComparisons.compareTo(first, second.getFirstComponent());
        int comp = fc + (lc = VersionSpecComparisons.compareTo(first, second.getLastComponent()));
        if (comp == 0) {
            return 0;
        }
        if (comp < 0) {
            return -1;
        }
        return 1;
    }

    private static int compareRangeToRange(RangeVersionSpec first, RangeVersionSpec second) {
        SingleVersion flb = first.getLowerBound();
        SingleVersion slb = second.getLowerBound();
        if (flb == null && slb == null) {
            return 0;
        }
        if (flb == null && slb != null) {
            return -1;
        }
        if (slb == null && flb != null) {
            return 1;
        }
        if (flb != null && slb != null) {
            int comp = VersionSpecComparisons.compareSingleToSingle(flb, slb);
            if (comp != 0) {
                return comp;
            }
            boolean flbi = first.isLowerBoundInclusive();
            boolean slbi = second.isLowerBoundInclusive();
            if (!flbi && slbi) {
                return -1;
            }
            if (flbi && !slbi) {
                return 1;
            }
            return 0;
        }
        SingleVersion fub = first.getUpperBound();
        SingleVersion sub = second.getUpperBound();
        if (fub != null && sub == null) {
            return -1;
        }
        if (sub != null && fub == null) {
            return 1;
        }
        if (fub != null && sub != null) {
            int comp = VersionSpecComparisons.compareSingleToSingle(fub, sub);
            if (comp != 0) {
                return comp;
            }
            boolean fubi = first.isUpperBoundInclusive();
            boolean subi = second.isUpperBoundInclusive();
            if (!fubi && subi) {
                return -1;
            }
            if (fubi && !subi) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private static int compareSingleToRange(SingleVersion first, RangeVersionSpec second) {
        SingleVersion lb = second.getLowerBound();
        if (lb == null) {
            SingleVersion ub = second.getUpperBound();
            if (ub == null) {
                return 0;
            }
            int comp = VersionSpecComparisons.compareSingleToSingle(first, ub);
            if (comp != 0) {
                return comp;
            }
            if (second.isUpperBoundInclusive()) {
                return 0;
            }
            return 1;
        }
        int comp = VersionSpecComparisons.compareSingleToSingle(first, lb);
        if (comp != 0) {
            return comp;
        }
        if (second.isLowerBoundInclusive()) {
            return 0;
        }
        return -1;
    }

    private static int compareSingleToSingle(SingleVersion first, SingleVersion second) {
        int comp = VersionSpecComparisons.comparePhrasesToPhrases(first.getVersionPhrases(), second.getVersionPhrases());
        if (comp == 0) {
            if (first.isRelease() && !second.isRelease()) {
                return 1;
            }
            if (second.isRelease() && !first.isRelease()) {
                return -1;
            }
        }
        return comp;
    }

    private static int comparePhrasesToPhrases(List<VersionPhrase> firstPhrases, List<VersionPhrase> secondPhrases) {
        VersionPhrase s;
        VersionPhrase f;
        int i;
        ArrayList<VersionPhrase> fp = new ArrayList<VersionPhrase>(firstPhrases);
        ArrayList<VersionPhrase> sp = new ArrayList<VersionPhrase>(secondPhrases);
        int comp = 0;
        for (i = Math.min(firstPhrases.size() - 1, secondPhrases.size() - 1); i < Math.max(firstPhrases.size(), secondPhrases.size()); ++i) {
            f = i < firstPhrases.size() ? firstPhrases.get(i) : null;
            s = i < secondPhrases.size() ? secondPhrases.get(i) : null;
            try {
                if (f == null) {
                    fp.add(new VersionPhrase(s.getSeparator(), NumericPart.ZERO));
                    continue;
                }
                if (s != null) continue;
                sp.add(new VersionPhrase(f.getSeparator(), NumericPart.ZERO));
                continue;
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
        for (i = 0; i < fp.size(); ++i) {
            f = (VersionPhrase)fp.get(i);
            comp = VersionSpecComparisons.comparePhraseToPhrase(f, s = (VersionPhrase)sp.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public static int comparePhraseToPhrase(VersionPhrase first, VersionPhrase second) {
        int comp;
        Integer fmi = first.getMarkerIndex();
        Integer smi = second.getMarkerIndex();
        if (fmi == null) {
            fmi = 0;
        }
        if (smi == null) {
            smi = 0;
        }
        if ((comp = fmi.compareTo(smi)) != 0) {
            return comp;
        }
        comp = VersionSpecComparisons.comparePartsToParts(first.getVersionParts(), second.getVersionParts());
        if (comp == 0) {
            if (first.isRelease() && !second.isRelease()) {
                return 1;
            }
            if (second.isRelease() && !first.isRelease()) {
                return -1;
            }
        }
        return comp;
    }

    private static int comparePartsToParts(List<VersionPart> first, List<VersionPart> second) {
        int i;
        ArrayList<VersionPart> fp = new ArrayList<VersionPart>(first);
        ArrayList<VersionPart> sp = new ArrayList<VersionPart>(second);
        for (i = Math.min(first.size() - 1, second.size() - 1); i < Math.max(first.size(), second.size()); ++i) {
            VersionPart s;
            VersionPart f = i < first.size() ? first.get(i) : null;
            VersionPart versionPart = s = i < second.size() ? second.get(i) : null;
            if (f == null) {
                if (s instanceof SeparatorPart) {
                    fp.add(s);
                    continue;
                }
                fp.add(NumericPart.ZERO);
                continue;
            }
            if (s != null) continue;
            if (f instanceof SeparatorPart) {
                sp.add(f);
                continue;
            }
            sp.add(NumericPart.ZERO);
        }
        for (i = 0; i < fp.size(); ++i) {
            VersionPart sPart;
            VersionPart fPart = (VersionPart)fp.get(i);
            int comp = fPart.compareTo(sPart = (VersionPart)sp.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }
}

