/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.ident.version.parse;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.commonjava.atlas.maven.ident.util.SnapshotUtils;
import org.commonjava.atlas.maven.ident.version.CompoundVersionSpec;
import org.commonjava.atlas.maven.ident.version.InvalidVersionSpecificationException;
import org.commonjava.atlas.maven.ident.version.RangeVersionSpec;
import org.commonjava.atlas.maven.ident.version.SingleVersion;
import org.commonjava.atlas.maven.ident.version.VersionSpec;
import org.commonjava.atlas.maven.ident.version.parse.ParseException;
import org.commonjava.atlas.maven.ident.version.parse.SimpleCharStream;
import org.commonjava.atlas.maven.ident.version.parse.Token;
import org.commonjava.atlas.maven.ident.version.parse.VersionParserConstants;
import org.commonjava.atlas.maven.ident.version.parse.VersionParserTokenManager;
import org.commonjava.atlas.maven.ident.version.part.NumericPart;
import org.commonjava.atlas.maven.ident.version.part.SeparatorPart;
import org.commonjava.atlas.maven.ident.version.part.SnapshotPart;
import org.commonjava.atlas.maven.ident.version.part.StringPart;
import org.commonjava.atlas.maven.ident.version.part.VersionPart;
import org.commonjava.atlas.maven.ident.version.part.VersionPartSeparator;

public class VersionParser
implements VersionParserConstants {
    private String rawSpec;
    public VersionParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[27];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    System.out.print("Enter version specification: ");
                    String expr = reader.readLine();
                    VersionParser parser = new VersionParser(expr);
                    VersionSpec version = parser.parse();
                    System.out.println(version);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public VersionParser(String expression) {
        this(new StringReader(expression));
        this.rawSpec = expression;
    }

    private RangeVersionSpec getRangeVersionSpec(SingleVersion lower, SingleVersion upper, boolean lowerInclusive, boolean upperInclusive) {
        return new RangeVersionSpec(this.rawSpec, lower, upper, lowerInclusive, upperInclusive);
    }

    private CompoundVersionSpec getCompoundVersionSpec(List<VersionSpec> specs) {
        return new CompoundVersionSpec(this.rawSpec, specs);
    }

    private SnapshotPart newSnapshotPart(String date, String buildnum) throws ParseException {
        try {
            return new SnapshotPart(SnapshotUtils.parseSnapshotTimestamp(date), Integer.parseInt(buildnum), date + "-" + buildnum);
        }
        catch (java.text.ParseException e) {
            ParseException pe = new ParseException("Failed to parse snapshot timestamp: '" + date + "'. Error: " + e.getMessage());
            pe.initCause(e);
            throw pe;
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException("Failed to parse snapshot build number: '" + buildnum + "'. Error: " + e.getMessage());
            pe.initCause(e);
            throw pe;
        }
    }

    private void addPart(List<VersionPart> parts, VersionPart current, VersionPart last) {
        if (last != null && !(last instanceof SeparatorPart) && !(current instanceof SeparatorPart)) {
            parts.add(new SeparatorPart(VersionPartSeparator.BLANK));
        }
        parts.add(current);
    }

    public final VersionSpec parse() throws ParseException, InvalidVersionSpecificationException {
        VersionSpec version = null;
        version = this.anySpec();
        return version;
    }

    public final VersionSpec anySpec() throws ParseException, InvalidVersionSpecificationException {
        ArrayList<VersionSpec> versions = new ArrayList<VersionSpec>();
        VersionSpec version = null;
        while (this.jj_2_1(20)) {
            version = this.anySingleSpec();
            versions.add(version);
        }
        if (versions.isEmpty()) {
            throw new InvalidVersionSpecificationException(this.rawSpec, "Cannot parse; no version specs found!", new Object[0]);
        }
        if (versions.size() == 1) {
            return (VersionSpec)versions.iterator().next();
        }
        return this.getCompoundVersionSpec(versions);
    }

    public final VersionSpec anySingleSpec() throws ParseException, InvalidVersionSpecificationException {
        VersionSpec version = null;
        if (this.jj_2_2(20)) {
            version = this.range();
        } else if (this.jj_2_3(20)) {
            version = this.single();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return version;
    }

    public final RangeVersionSpec range() throws ParseException, InvalidVersionSpecificationException {
        RangeVersionSpec spec = null;
        if (this.jj_2_4(20)) {
            spec = this.trueRange();
        } else if (this.jj_2_5(20)) {
            spec = this.pinnedRange();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return spec;
    }

    public final RangeVersionSpec trueRange() throws ParseException, InvalidVersionSpecificationException {
        SingleVersion lower = null;
        boolean lowerInclusive = true;
        SingleVersion upper = null;
        boolean upperInclusive = true;
        if (this.jj_2_6(20)) {
            this.jj_consume_token(3);
            lowerInclusive = false;
        } else if (this.jj_2_7(20)) {
            this.jj_consume_token(5);
            lowerInclusive = true;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (this.jj_2_8(20)) {
            lower = this.single();
        }
        this.jj_consume_token(2);
        if (this.jj_2_9(20)) {
            upper = this.single();
        }
        if (this.jj_2_10(20)) {
            this.jj_consume_token(4);
            upperInclusive = false;
        } else if (this.jj_2_11(20)) {
            this.jj_consume_token(6);
            upperInclusive = true;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return this.getRangeVersionSpec(lower, upper, lowerInclusive, upperInclusive);
    }

    public final RangeVersionSpec pinnedRange() throws ParseException, InvalidVersionSpecificationException {
        SingleVersion version = null;
        this.jj_consume_token(5);
        version = this.single();
        this.jj_consume_token(6);
        return this.getRangeVersionSpec(version, version, true, true);
    }

    public final SingleVersion single() throws ParseException, InvalidVersionSpecificationException {
        SeparatorPart sepPart;
        NumericPart subSeg;
        int subIdx;
        String[] subParts;
        ArrayList<VersionPart> parts = new ArrayList<VersionPart>();
        VersionPart seg = null;
        VersionPart last = null;
        seg = this.segment();
        if (seg instanceof StringPart && ((StringPart)seg).getValue().indexOf(".") > -1) {
            subParts = ((StringPart)seg).getValue().split("\\.");
            for (subIdx = 0; subIdx < subParts.length; ++subIdx) {
                subSeg = new NumericPart(subParts[subIdx]);
                this.addPart(parts, subSeg, last);
                last = subSeg;
                if (subIdx + 1 >= subParts.length) continue;
                sepPart = new SeparatorPart(VersionPartSeparator.DOT);
                this.addPart(parts, sepPart, last);
                last = sepPart;
            }
        } else {
            this.addPart(parts, seg, last);
            last = seg;
        }
        while (this.jj_2_12(20)) {
            if (this.jj_2_13(20)) {
                seg = this.separator();
                this.addPart(parts, seg, last);
                last = seg;
            }
            if (this.jj_2_14(20)) {
                seg = this.snapshot();
                this.addPart(parts, seg, last);
                last = seg;
                continue;
            }
            if (this.jj_2_15(20)) {
                seg = this.segment();
                if (seg instanceof StringPart && ((StringPart)seg).getValue().indexOf(".") > -1) {
                    subParts = ((StringPart)seg).getValue().split("\\.");
                    for (subIdx = 0; subIdx < subParts.length; ++subIdx) {
                        subSeg = new NumericPart(subParts[subIdx]);
                        this.addPart(parts, subSeg, last);
                        last = subSeg;
                        if (subIdx + 1 >= subParts.length) continue;
                        sepPart = new SeparatorPart(VersionPartSeparator.DOT);
                        this.addPart(parts, sepPart, last);
                        last = sepPart;
                    }
                    continue;
                }
                this.addPart(parts, seg, last);
                last = seg;
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return new SingleVersion(this.rawSpec, parts);
    }

    public final VersionPart segment() throws ParseException {
        VersionPart part = null;
        StringBuilder num = new StringBuilder();
        Token val = null;
        if (this.jj_2_17(20)) {
            part = this.snapshot();
        } else if (this.jj_2_18(20)) {
            val = this.jj_consume_token(12);
            part = new StringPart(val.image);
        } else if (this.jj_2_19(20)) {
            while (true) {
                val = this.jj_consume_token(14);
                num.append(val.image);
                if (this.jj_2_16(20)) {
                    continue;
                }
                break;
            }
        } else if (this.jj_2_20(20)) {
            val = this.jj_consume_token(13);
            part = new StringPart(val.image);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return part == null ? new NumericPart(num.toString()) : part;
    }

    public final VersionPart snapshot() throws ParseException {
        SnapshotPart part = null;
        String ts = null;
        StringBuilder bn = new StringBuilder();
        Token token = null;
        if (this.jj_2_22(20)) {
            token = this.jj_consume_token(12);
            ts = token.image;
            this.jj_consume_token(7);
            while (true) {
                token = this.jj_consume_token(14);
                bn.append(token.image);
                if (this.jj_2_21(20)) {
                    continue;
                }
                break;
            }
        } else if (this.jj_2_23(20)) {
            token = this.jj_consume_token(11);
            part = new SnapshotPart(token.image);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return part == null ? this.newSnapshotPart(ts, bn.toString()) : part;
    }

    public final SeparatorPart separator() throws ParseException {
        VersionPartSeparator sep = null;
        if (this.jj_2_24(20)) {
            this.jj_consume_token(9);
            sep = VersionPartSeparator.DOT;
        } else if (this.jj_2_25(20)) {
            this.jj_consume_token(7);
            sep = VersionPartSeparator.DASH;
        } else if (this.jj_2_26(20)) {
            this.jj_consume_token(10);
            sep = VersionPartSeparator.PLUS;
        } else if (this.jj_2_27(20)) {
            this.jj_consume_token(8);
            sep = VersionPartSeparator.UNDERSCORE;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return new SeparatorPart(sep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    private boolean jj_3R_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_19()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_20()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_3R_10();
    }

    private boolean jj_3_23() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_21() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3_5() {
        return this.jj_3R_9();
    }

    private boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_22() {
        Token xsp;
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_3_21()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_21());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_11() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_23()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_7();
    }

    private boolean jj_3_2() {
        return this.jj_3R_6();
    }

    private boolean jj_3_10() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_9() {
        return this.jj_3R_7();
    }

    private boolean jj_3_8() {
        return this.jj_3R_7();
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_27() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_7() {
        Token xsp;
        if (this.jj_3R_12()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_12());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_26() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3_20() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3_16() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3_25() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3_15() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_7()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_24() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_19() {
        Token xsp;
        if (this.jj_3_16()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_16());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_25()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_26()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_27()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_18() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3_14() {
        return this.jj_3R_11();
    }

    private boolean jj_3_1() {
        return this.jj_3R_5();
    }

    private boolean jj_3_17() {
        return this.jj_3R_11();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    public VersionParser(InputStream stream) {
        this(stream, null);
    }

    public VersionParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new VersionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public VersionParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new VersionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public VersionParser(VersionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(VersionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[15];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 15; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 27; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        VersionParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

