/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.ident.version.part;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.commonjava.atlas.maven.ident.version.part.NumericPart;
import org.commonjava.atlas.maven.ident.version.part.SnapshotPart;
import org.commonjava.atlas.maven.ident.version.part.VersionPart;

public class StringPart
extends VersionPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ZERO_EQUIV = "";
    private static final String RANDOM_STRING_EQUIV = "_random";
    private static final List<String> MARKER_ORDER = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("PREVIEW");
            this.add("MILESTONE");
            this.add("ALPHA");
            this.add("BETA");
            this.add("RC");
            this.add(StringPart.ZERO_EQUIV);
            this.add("SP");
            this.add(StringPart.RANDOM_STRING_EQUIV);
        }
    };
    private static final int ZERO_EQUIV_INDEX = MARKER_ORDER.indexOf("");
    public static final int ADJ_ZERO_EQUIV_INDEX = ZERO_EQUIV_INDEX - MARKER_ORDER.size();
    private static final int RANDOM_STRING_EQUIV_INDEX = MARKER_ORDER.indexOf("_random");
    public static final int ADJ_RANDOM_STRING_EQUIV_INDEX = RANDOM_STRING_EQUIV_INDEX - MARKER_ORDER.size();
    private static final Map<String, String> ALIASES = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("PRE", "PREVIEW");
            this.put("M", "MILESTONE");
            this.put("A", "ALPHA");
            this.put("B", "BETA");
            this.put("CR", "RC");
            this.put("GA", StringPart.ZERO_EQUIV);
            this.put("FINAL", StringPart.ZERO_EQUIV);
            this.put("CP", "SP");
        }
    };
    private final String value;
    private final Integer zeroCompareIndex;

    public StringPart(String value) {
        int idx;
        this.value = value;
        String uc = value.toUpperCase();
        if (ALIASES.containsKey(uc)) {
            uc = ALIASES.get(uc);
        }
        idx = (idx = MARKER_ORDER.indexOf(uc)) > -1 ? (idx -= MARKER_ORDER.size()) : ADJ_RANDOM_STRING_EQUIV_INDEX;
        this.zeroCompareIndex = idx;
    }

    public boolean isMarker() {
        return this.zeroCompareIndex != ADJ_RANDOM_STRING_EQUIV_INDEX;
    }

    public Integer getZeroCompareIndex() {
        return this.zeroCompareIndex;
    }

    @Override
    public String renderStandard() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("STR[%s]", this.value);
    }

    @Override
    public int compareTo(VersionPart part) {
        if (part instanceof SnapshotPart) {
            Integer idx = this.zeroCompareIndex == null ? 1 : this.zeroCompareIndex;
            return idx.compareTo(ADJ_ZERO_EQUIV_INDEX);
        }
        if (part instanceof NumericPart) {
            if (!NumericPart.ZERO.equals(part)) {
                return -1;
            }
            Integer idx = this.zeroCompareIndex == null ? 1 : this.zeroCompareIndex;
            return idx.compareTo(ADJ_ZERO_EQUIV_INDEX);
        }
        if (part instanceof StringPart) {
            StringPart otherStr = (StringPart)part;
            Integer zci = this.zeroCompareIndex;
            Integer ozci = otherStr.getZeroCompareIndex();
            if (zci == ADJ_RANDOM_STRING_EQUIV_INDEX && ozci == ADJ_RANDOM_STRING_EQUIV_INDEX) {
                return this.value.toLowerCase(Locale.ENGLISH).compareTo(otherStr.getValue().toLowerCase(Locale.ENGLISH));
            }
            return zci.compareTo(ozci);
        }
        if (part instanceof SnapshotPart) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.zeroCompareIndex == null ? 0 : this.zeroCompareIndex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringPart other = (StringPart)obj;
        Integer zci = this.zeroCompareIndex;
        Integer ozci = other.getZeroCompareIndex();
        if (zci == ADJ_RANDOM_STRING_EQUIV_INDEX && ozci == ADJ_RANDOM_STRING_EQUIV_INDEX) {
            if (this.value == null && other.value != null) {
                return false;
            }
            return this.value.toLowerCase(Locale.ENGLISH).equals(other.getValue().toLowerCase(Locale.ENGLISH));
        }
        return zci.equals(ozci);
    }
}

