/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.ident.version.part;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.commonjava.atlas.maven.ident.version.InvalidVersionSpecificationException;
import org.commonjava.atlas.maven.ident.version.VersionSpecComparisons;
import org.commonjava.atlas.maven.ident.version.part.NumericPart;
import org.commonjava.atlas.maven.ident.version.part.SeparatorPart;
import org.commonjava.atlas.maven.ident.version.part.SnapshotPart;
import org.commonjava.atlas.maven.ident.version.part.StringPart;
import org.commonjava.atlas.maven.ident.version.part.VersionPart;
import org.commonjava.atlas.maven.ident.version.part.VersionPartSeparator;

public class VersionPhrase
implements Comparable<VersionPhrase>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<VersionPart> parts;
    private final VersionPartSeparator separator;
    private final Integer markerIndex;
    private boolean silent = false;

    public VersionPhrase(VersionPartSeparator separator, VersionPart ... parts) throws InvalidVersionSpecificationException {
        this(separator, Arrays.asList(parts));
    }

    public VersionPhrase(VersionPartSeparator separator, List<VersionPart> p) throws InvalidVersionSpecificationException {
        this.separator = separator;
        List<VersionPart> parts = new ArrayList<VersionPart>(p);
        parts = this.normalize(parts);
        this.validate(parts);
        this.markSilentParts(parts);
        this.markerIndex = this.findMarkerIndex(parts.get(0));
        this.parts = new ArrayList<VersionPart>(parts);
    }

    private void markSilentParts(List<VersionPart> parts) {
        for (int i = parts.size() - 1; i > -1; --i) {
            VersionPart part = parts.get(i);
            boolean silenced = false;
            if (NumericPart.ZERO.equals(part)) {
                silenced = true;
            } else if (part instanceof SeparatorPart) {
                silenced = true;
            } else if (part instanceof StringPart && ((StringPart)part).getZeroCompareIndex() == StringPart.ADJ_ZERO_EQUIV_INDEX) {
                silenced = true;
            }
            if (!silenced) break;
            part.setSilent(true);
        }
        if (parts.get(0).isSilent()) {
            this.silent = true;
        }
    }

    public boolean isSilent() {
        return this.silent;
    }

    private Integer findMarkerIndex(VersionPart part) {
        Integer markerIndex = null;
        if (part instanceof StringPart) {
            markerIndex = ((StringPart)part).getZeroCompareIndex();
        } else if (part instanceof SnapshotPart) {
            markerIndex = StringPart.ADJ_ZERO_EQUIV_INDEX;
        } else if (part instanceof NumericPart && ((NumericPart)part).equals(NumericPart.ZERO)) {
            markerIndex = StringPart.ADJ_ZERO_EQUIV_INDEX;
        }
        return markerIndex;
    }

    public VersionPartSeparator getSeparator() {
        return this.separator;
    }

    public Integer getMarkerIndex() {
        return this.markerIndex;
    }

    private List<VersionPart> normalize(List<VersionPart> parts) {
        VersionPart prev = null;
        ArrayList<VersionPart> result = new ArrayList<VersionPart>(parts.size());
        for (int i = 0; i < parts.size(); ++i) {
            VersionPart part = parts.get(i);
            if (prev != null && !(prev instanceof SeparatorPart) && !(part instanceof SeparatorPart)) {
                SeparatorPart sep = new SeparatorPart(VersionPartSeparator.BLANK);
                result.add(sep);
                prev = sep;
                --i;
                continue;
            }
            result.add(part);
            prev = part;
        }
        if (!result.isEmpty() && result.get(result.size() - 1) instanceof SeparatorPart) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private void validate(List<VersionPart> parts) throws InvalidVersionSpecificationException {
        if (parts.isEmpty()) {
            throw new InvalidVersionSpecificationException(this.renderStandard(parts), "Empty versions are not allowed", new Object[0]);
        }
        for (VersionPart part : parts) {
            if (part == parts.get(parts.size() - 1) || !(part instanceof SnapshotPart)) continue;
            throw new InvalidVersionSpecificationException(this.renderStandard(parts), "Snapshot marker MUST appear at the end of the version", new Object[0]);
        }
    }

    public VersionPhrase getBaseVersion() throws InvalidVersionSpecificationException {
        if (this.isRelease()) {
            return this;
        }
        try {
            return new VersionPhrase(this.separator, this.parts.subList(0, this.parts.size() - 2));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new InvalidVersionSpecificationException(e.getVersion(), "Cannot create base version for non-release: %s. Reason: %s", e, e.getVersion(), e.getMessage());
        }
    }

    public String renderDebug() {
        StringBuilder sb = new StringBuilder();
        sb.append("PHRASE[sep=").append(this.separator == null ? "NULL" : this.separator.getRenderedString()).append(", parts=(");
        for (VersionPart part : this.parts) {
            sb.append(part).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(")] (").append(this.renderStandard()).append(")");
        return sb.toString();
    }

    public String renderStandard() {
        return (this.separator == null ? "" : this.separator.getRenderedString()) + this.renderStandard(this.parts);
    }

    private String renderStandard(List<VersionPart> parts) {
        StringBuilder sb = new StringBuilder();
        for (VersionPart part : parts) {
            sb.append(part.renderStandard());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(VersionPhrase other) {
        return VersionSpecComparisons.comparePhraseToPhrase(this, other);
    }

    public boolean isRelease() {
        for (VersionPart part : this.parts) {
            if (!(part instanceof SnapshotPart)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.renderStandard();
    }

    public boolean isConcrete() {
        return this.isRelease();
    }

    public boolean isSingle() {
        return true;
    }

    public VersionPhrase getConcreteVersion() {
        return this.isConcrete() ? this : null;
    }

    public VersionPhrase getSingleVersion() {
        return this.isSingle() ? this : null;
    }

    public List<VersionPart> getVersionParts() {
        return this.parts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.parts != null) {
            for (VersionPart part : this.parts) {
                if (part.isSilent()) continue;
                result += part.hashCode();
            }
        }
        return 31 * result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionPhrase other = (VersionPhrase)obj;
        if (this.parts == null) {
            if (other.parts != null) {
                return false;
            }
        } else {
            VersionPart theirs;
            int i;
            ArrayList<VersionPart> myParts = new ArrayList<VersionPart>(this.parts);
            Iterator it = myParts.iterator();
            while (it.hasNext()) {
                VersionPart part = (VersionPart)it.next();
                if (!(part instanceof SeparatorPart)) continue;
                it.remove();
            }
            ArrayList<VersionPart> theirParts = new ArrayList<VersionPart>(other.parts);
            Iterator it2 = theirParts.iterator();
            while (it2.hasNext()) {
                VersionPart part = (VersionPart)it2.next();
                if (!(part instanceof SeparatorPart)) continue;
                it2.remove();
            }
            for (i = 0; i < Math.min(myParts.size(), theirParts.size()); ++i) {
                VersionPart mine = (VersionPart)myParts.get(i);
                theirs = (VersionPart)theirParts.get(i);
                if (mine.isSilent() != theirs.isSilent()) {
                    return false;
                }
                if (mine.isSilent() || theirs.isSilent() || mine.equals(theirs)) continue;
                return false;
            }
            if (i < myParts.size()) {
                for (int j = i; j < myParts.size(); ++j) {
                    VersionPart mine = (VersionPart)myParts.get(j);
                    if (mine.isSilent()) continue;
                    return false;
                }
            }
            if (i < theirParts.size()) {
                for (int j = i; j < theirParts.size(); ++j) {
                    theirs = (VersionPart)theirParts.get(j);
                    if (theirs.isSilent()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isSnapshotOnly() {
        return this.parts.size() == 1 && this.isSnapshot();
    }

    public boolean isSnapshot() {
        return this.parts.get(this.parts.size() - 1) instanceof SnapshotPart;
    }
}

