/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.graph.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.commonjava.atlas.maven.graph.jackson.PluginKeyDeserializer;
import org.commonjava.atlas.maven.graph.jackson.PluginKeySerializer;
import org.commonjava.atlas.maven.graph.jackson.ProjectRelationshipDeserializer;
import org.commonjava.atlas.maven.graph.jackson.ProjectRelationshipSerializer;
import org.commonjava.atlas.maven.graph.model.PluginKey;
import org.commonjava.atlas.maven.graph.rel.BomRelationship;
import org.commonjava.atlas.maven.graph.rel.DependencyRelationship;
import org.commonjava.atlas.maven.graph.rel.ExtensionRelationship;
import org.commonjava.atlas.maven.graph.rel.ParentRelationship;
import org.commonjava.atlas.maven.graph.rel.PluginDependencyRelationship;
import org.commonjava.atlas.maven.graph.rel.PluginRelationship;
import org.commonjava.atlas.maven.graph.rel.ProjectRelationship;
import org.commonjava.atlas.maven.graph.rel.SimpleBomRelationship;
import org.commonjava.atlas.maven.graph.rel.SimpleDependencyRelationship;
import org.commonjava.atlas.maven.graph.rel.SimpleExtensionRelationship;
import org.commonjava.atlas.maven.graph.rel.SimpleParentRelationship;
import org.commonjava.atlas.maven.graph.rel.SimplePluginDependencyRelationship;
import org.commonjava.atlas.maven.graph.rel.SimplePluginRelationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRelationshipSerializerModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends ProjectRelationship>> REL_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(ProjectRelationship.class, BomRelationship.class, DependencyRelationship.class, ExtensionRelationship.class, ParentRelationship.class, PluginDependencyRelationship.class, PluginRelationship.class, SimpleBomRelationship.class, SimpleDependencyRelationship.class, SimpleExtensionRelationship.class, SimpleParentRelationship.class, SimplePluginDependencyRelationship.class, SimplePluginRelationship.class)));
    public static final ProjectRelationshipSerializerModule INSTANCE = new ProjectRelationshipSerializerModule();

    public ProjectRelationshipSerializerModule() {
        super("ProjectRelationship<?> Serializer");
        for (Class<? extends ProjectRelationship> cls : REL_CLASSES) {
            this.register(cls);
        }
        this.addKeySerializer(PluginKey.class, new PluginKeySerializer());
        this.addKeyDeserializer(PluginKey.class, new PluginKeyDeserializer());
    }

    private <T extends ProjectRelationship> void register(Class<T> cls) {
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        logger.debug("Registering serializer/deserializer for: {}", (Object)cls.getSimpleName());
        this.addSerializer(cls, (JsonSerializer)new ProjectRelationshipSerializer<T>(cls));
        this.addDeserializer(cls, (JsonDeserializer)new ProjectRelationshipDeserializer());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().getSimpleName().hashCode() + 17;
    }

    public boolean equals(Object other) {
        return ((Object)((Object)this)).getClass().equals(other.getClass());
    }
}

