/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.graph.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonjava.atlas.maven.graph.model.EProjectRelationshipCollection;
import org.commonjava.atlas.maven.graph.model.PluginKey;
import org.commonjava.atlas.maven.graph.rel.BomRelationship;
import org.commonjava.atlas.maven.graph.rel.DependencyRelationship;
import org.commonjava.atlas.maven.graph.rel.ExtensionRelationship;
import org.commonjava.atlas.maven.graph.rel.ParentRelationship;
import org.commonjava.atlas.maven.graph.rel.PluginDependencyRelationship;
import org.commonjava.atlas.maven.graph.rel.PluginRelationship;
import org.commonjava.atlas.maven.graph.rel.ProjectRelationship;
import org.commonjava.atlas.maven.graph.rel.RelationshipConstants;
import org.commonjava.atlas.maven.graph.rel.SimpleDependencyRelationship;
import org.commonjava.atlas.maven.graph.rel.SimpleExtensionRelationship;
import org.commonjava.atlas.maven.graph.rel.SimpleParentRelationship;
import org.commonjava.atlas.maven.graph.rel.SimplePluginRelationship;
import org.commonjava.atlas.maven.graph.util.RelationshipUtils;
import org.commonjava.atlas.maven.ident.DependencyScope;
import org.commonjava.atlas.maven.ident.ref.ArtifactRef;
import org.commonjava.atlas.maven.ident.ref.ProjectRef;
import org.commonjava.atlas.maven.ident.ref.ProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleArtifactRef;

public class EProjectDirectRelationships
implements EProjectRelationshipCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private URI source;
    private ProjectVersionRef projectRef;
    private List<BomRelationship> boms;
    private List<DependencyRelationship> dependencies;
    private List<DependencyRelationship> managedDependencies;
    private List<PluginRelationship> plugins;
    private List<PluginRelationship> managedPlugins;
    private List<ExtensionRelationship> extensions;
    private ParentRelationship parent;
    private Map<PluginKey, List<PluginDependencyRelationship>> pluginDependencies;

    public EProjectDirectRelationships() {
    }

    public EProjectDirectRelationships(URI source, ProjectVersionRef ref, ParentRelationship parent, List<BomRelationship> boms, List<DependencyRelationship> dependencies, List<PluginRelationship> plugins, List<DependencyRelationship> managedDependencies, List<PluginRelationship> managedPlugins, List<ExtensionRelationship> extensions, Map<PluginKey, List<PluginDependencyRelationship>> pluginDependencies) {
        this.source = source;
        this.projectRef = ref;
        this.parent = parent;
        this.boms = Collections.unmodifiableList(boms);
        this.dependencies = Collections.unmodifiableList(dependencies);
        this.plugins = Collections.unmodifiableList(plugins);
        this.managedDependencies = Collections.unmodifiableList(managedDependencies);
        this.managedPlugins = Collections.unmodifiableList(managedPlugins);
        this.extensions = Collections.unmodifiableList(extensions);
        HashMap<PluginKey, List<PluginDependencyRelationship>> pdrels = new HashMap<PluginKey, List<PluginDependencyRelationship>>();
        for (Map.Entry<PluginKey, List<PluginDependencyRelationship>> entry : pluginDependencies.entrySet()) {
            pdrels.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        this.pluginDependencies = Collections.unmodifiableMap(pdrels);
    }

    public final URI getSource() {
        return this.source;
    }

    public final ProjectVersionRef getProjectRef() {
        return this.projectRef;
    }

    public final List<DependencyRelationship> getDependencies() {
        return this.dependencies;
    }

    public final List<DependencyRelationship> getManagedDependencies() {
        return this.managedDependencies;
    }

    public final List<PluginRelationship> getPlugins() {
        return this.plugins;
    }

    public final List<PluginRelationship> getManagedPlugins() {
        return this.managedPlugins;
    }

    public final List<ExtensionRelationship> getExtensions() {
        return this.extensions;
    }

    public final ParentRelationship getParent() {
        return this.parent;
    }

    public final Map<PluginKey, List<PluginDependencyRelationship>> getPluginDependencies() {
        return this.pluginDependencies;
    }

    public final List<PluginDependencyRelationship> getPluginDependencies(ProjectVersionRef plugin, boolean managed, boolean inherited) {
        PluginKey pk = new PluginKey(plugin, managed);
        return this.pluginDependencies.get(pk);
    }

    public final List<BomRelationship> getBoms() {
        return this.boms;
    }

    @JsonIgnore
    public Set<ProjectRelationship<?, ?>> getAllRelationships() {
        Collection rels = this.getExactAllRelationships();
        RelationshipUtils.filterTerminalParents(rels);
        return rels;
    }

    @JsonIgnore
    public Set<ProjectRelationship<?, ?>> getExactAllRelationships() {
        HashSet result = new HashSet();
        if (this.parent != null) {
            result.add(this.parent);
        }
        result.addAll(this.boms);
        result.addAll(this.dependencies);
        result.addAll(this.managedDependencies);
        result.addAll(this.plugins);
        result.addAll(this.managedPlugins);
        result.addAll(this.extensions);
        for (List<PluginDependencyRelationship> pluginRels : this.pluginDependencies.values()) {
            result.addAll(pluginRels);
        }
        return result;
    }

    public static final class Builder {
        private final URI source;
        private final ProjectVersionRef ref;
        private final List<BomRelationship> boms = new ArrayList<BomRelationship>();
        private final List<DependencyRelationship> dependencies = new ArrayList<DependencyRelationship>();
        private final List<DependencyRelationship> managedDependencies = new ArrayList<DependencyRelationship>();
        private final List<PluginRelationship> plugins = new ArrayList<PluginRelationship>();
        private final List<PluginRelationship> managedPlugins = new ArrayList<PluginRelationship>();
        private final List<ExtensionRelationship> extensions = new ArrayList<ExtensionRelationship>();
        private ParentRelationship parent;
        private final Map<PluginKey, List<PluginDependencyRelationship>> pluginDependencies = new HashMap<PluginKey, List<PluginDependencyRelationship>>();

        public Builder(URI source, ProjectVersionRef projectRef, String ... activeProfiles) {
            this.source = source;
            this.ref = projectRef;
        }

        public EProjectDirectRelationships build() {
            if (this.parent == null) {
                this.parent = new SimpleParentRelationship(this.ref);
            }
            return new EProjectDirectRelationships(this.source, this.ref, this.parent, this.boms, this.dependencies, this.plugins, this.managedDependencies, this.managedPlugins, this.extensions, this.pluginDependencies);
        }

        public Builder withParent(ProjectVersionRef parent) {
            this.parent = new SimpleParentRelationship(this.source, this.ref, parent);
            return this;
        }

        public Builder withParent(ParentRelationship parent) {
            this.parent = this.adjustDeclaring(parent);
            return this;
        }

        private <C extends ProjectRelationship<?, ?>> C adjustDeclaring(C rel) {
            if (!this.ref.equals(rel.getDeclaring())) {
                return (C)rel.cloneFor(this.ref);
            }
            return rel;
        }

        public Builder withBoms(BomRelationship ... boms) {
            return this.withBoms(Arrays.asList(boms));
        }

        public Builder withBoms(Collection<BomRelationship> boms) {
            for (BomRelationship bom : boms) {
                bom = this.adjustDeclaring(bom);
                this.boms.add(bom);
            }
            return this;
        }

        public Builder withDependencies(DependencyRelationship ... deps) {
            return this.withDependencies(Arrays.asList(deps));
        }

        public Builder withDependencies(Collection<DependencyRelationship> deps) {
            for (DependencyRelationship dep : deps) {
                if ((dep = this.adjustDeclaring(dep)).isManaged()) {
                    if (this.managedDependencies.contains(dep)) continue;
                    this.managedDependencies.add(dep);
                    continue;
                }
                if (this.dependencies.contains(dep)) continue;
                this.dependencies.add(dep);
            }
            return this;
        }

        public Builder withPlugins(PluginRelationship ... plugins) {
            return this.withPlugins(Arrays.asList(plugins));
        }

        public Builder withPlugins(Collection<PluginRelationship> plugins) {
            for (PluginRelationship plugin : plugins) {
                if ((plugin = this.adjustDeclaring(plugin)).isManaged()) {
                    if (this.managedPlugins.contains(plugin)) continue;
                    this.managedPlugins.add(plugin);
                    continue;
                }
                if (this.plugins.contains(plugin)) continue;
                this.plugins.add(plugin);
            }
            return this;
        }

        public Builder withPluginDependencies(PluginDependencyRelationship ... pluginDeps) {
            return this.withPluginDependencies(Arrays.asList(pluginDeps));
        }

        public Builder withPluginDependencies(Collection<PluginDependencyRelationship> pluginDeps) {
            for (PluginDependencyRelationship rel : pluginDeps) {
                rel = this.adjustDeclaring(rel);
                ProjectRef pluginRef = rel.getPlugin();
                PluginKey pk = null;
                if (rel.isManaged()) {
                    for (PluginRelationship pluginRel : this.managedPlugins) {
                        if (!pluginRef.equals(pluginRel.getTarget())) continue;
                        pk = new PluginKey(pluginRel);
                        break;
                    }
                } else {
                    for (PluginRelationship pluginRel : this.plugins) {
                        if (!pluginRef.equals(pluginRel.getTarget())) continue;
                        pk = new PluginKey(pluginRel);
                        break;
                    }
                }
                if (pk == null) {
                    throw new IllegalArgumentException("Orphaned plugin-level dependency found: " + rel + ". Make sure you load plugin relationships BEFORE attempting to load plugin-dependency-relationships.");
                }
                List<PluginDependencyRelationship> pdrs = this.pluginDependencies.get(pk);
                if (pdrs == null) {
                    pdrs = new ArrayList<PluginDependencyRelationship>();
                    this.pluginDependencies.put(pk, pdrs);
                }
                if (pdrs.contains(rel)) continue;
                pdrs.add(rel);
            }
            return this;
        }

        public Builder withExtensions(ExtensionRelationship ... exts) {
            return this.withExtensions(Arrays.asList(exts));
        }

        public Builder withExtensions(Collection<ExtensionRelationship> exts) {
            for (ExtensionRelationship ext : exts) {
                if (this.extensions.contains(ext)) continue;
                this.extensions.add(this.adjustDeclaring(ext));
            }
            return this;
        }

        public Builder withRelationships(Collection<ProjectRelationship<?, ?>> relationships) {
            HashSet<PluginDependencyRelationship> pluginDepRels = new HashSet<PluginDependencyRelationship>();
            for (ProjectRelationship<?, ?> rel : relationships) {
                rel = this.adjustDeclaring(rel);
                switch (rel.getType()) {
                    case BOM: {
                        this.withBoms((BomRelationship)rel);
                        break;
                    }
                    case DEPENDENCY: {
                        this.withDependencies((DependencyRelationship)rel);
                        break;
                    }
                    case PLUGIN: {
                        this.withPlugins((PluginRelationship)rel);
                        break;
                    }
                    case EXTENSION: {
                        this.withExtensions((ExtensionRelationship)rel);
                        break;
                    }
                    case PLUGIN_DEP: {
                        pluginDepRels.add((PluginDependencyRelationship)rel);
                        break;
                    }
                    case PARENT: {
                        this.withParent((ParentRelationship)rel);
                    }
                }
            }
            this.withPluginDependencies(pluginDepRels);
            return this;
        }

        public int getNextPluginIndex(boolean managed) {
            return managed ? this.managedPlugins.size() : this.plugins.size();
        }

        public int getNextPluginDependencyIndex(ProjectVersionRef plugin, boolean managed, boolean inherited) {
            List<PluginDependencyRelationship> list = this.pluginDependencies.get(new PluginKey(plugin, managed));
            return list == null ? 0 : list.size();
        }

        public int getNextDependencyIndex(boolean managed) {
            return managed ? this.managedDependencies.size() : this.dependencies.size();
        }

        public int getNextExtensionIndex() {
            return this.extensions.size();
        }

        public Builder withDependency(ProjectVersionRef ref, String type, String classifier, DependencyScope scope, boolean managed, boolean inherited, boolean optional) {
            this.withDependencies(new SimpleDependencyRelationship(this.source, ref, (ArtifactRef)new SimpleArtifactRef(ref, type, classifier), scope, this.getNextDependencyIndex(managed), managed, inherited, optional, new ProjectRef[0]));
            return this;
        }

        public Builder withPlugin(ProjectVersionRef ref, boolean managed, boolean inherited) {
            this.withPlugins(new SimplePluginRelationship(this.source, ref, ref, this.getNextPluginIndex(managed), managed, inherited));
            return this;
        }

        public Builder withExtension(ProjectVersionRef ref, boolean inherited) {
            this.withExtensions(new SimpleExtensionRelationship(this.source, RelationshipConstants.POM_ROOT_URI, ref, ref, this.getNextExtensionIndex(), inherited));
            return this;
        }

        public ProjectVersionRef getProjectRef() {
            return this.ref;
        }
    }
}

