/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.graph.model;

import java.io.Serializable;
import org.commonjava.atlas.maven.graph.rel.PluginRelationship;
import org.commonjava.atlas.maven.ident.ref.ProjectVersionRef;

public final class PluginKey
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private boolean managed;

    public PluginKey() {
    }

    public PluginKey(ProjectVersionRef target, boolean managed) {
        this.groupId = target.getGroupId();
        this.artifactId = target.getArtifactId();
        this.version = target.getVersionString();
        this.managed = managed;
    }

    public PluginKey(PluginRelationship rel) {
        this((ProjectVersionRef)rel.getTarget(), rel.isManaged());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getManaged() {
        return this.managed;
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.groupId, this.artifactId, this.version, this.managed);
    }

    public static PluginKey parse(String pk) {
        String[] parts = pk.split(":");
        if (parts.length < 4) {
            throw new RuntimeException("PluginKey parse failed. (Given: '" + pk + "')");
        }
        PluginKey ret = new PluginKey();
        ret.groupId = parts[0];
        ret.artifactId = parts[1];
        ret.version = parts[2];
        ret.managed = Boolean.parseBoolean(parts[3]);
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginKey)) {
            return false;
        }
        PluginKey other = (PluginKey)obj;
        if (this.groupId == null ? other.getGroupId() != null : !this.groupId.equals(other.getGroupId())) {
            return false;
        }
        if (this.artifactId == null ? other.getArtifactId() != null : !this.artifactId.equals(other.getArtifactId())) {
            return false;
        }
        if (this.version == null ? other.getVersion() != null : !this.version.equals(other.getVersion())) {
            return false;
        }
        return this.managed == other.getManaged();
    }
}

