/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.graph.rel;

import java.util.Comparator;
import java.util.List;
import org.commonjava.atlas.maven.graph.rel.ProjectRelationship;
import org.commonjava.atlas.maven.graph.rel.RelationshipComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipPathComparator
implements Comparator<List<ProjectRelationship<?, ?>>> {
    public static RelationshipPathComparator INSTANCE = new RelationshipPathComparator();
    private final RelationshipComparator comp = RelationshipComparator.INSTANCE;

    private RelationshipPathComparator() {
    }

    @Override
    public int compare(List<ProjectRelationship<?, ?>> one, List<ProjectRelationship<?, ?>> two) {
        int result;
        int i;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug("Comparing:\nOne: {}\nTwo: {}", one, two);
        int commonLen = Math.min(one.size(), two.size());
        if (one.size() > commonLen) {
            return 1;
        }
        if (two.size() > commonLen) {
            return -1;
        }
        for (i = 0; i < commonLen; ++i) {
            result = this.compareRelTypes(one.get(i), two.get(i));
            if (result == 0) continue;
            return result;
        }
        for (i = 0; i < commonLen; ++i) {
            result = this.compareRels(one.get(i), two.get(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compareRels(ProjectRelationship<?, ?> one, ProjectRelationship<?, ?> two) {
        return this.comp.compare(one, two);
    }

    private int compareRelTypes(ProjectRelationship<?, ?> one, ProjectRelationship<?, ?> two) {
        return one.getType().ordinal() - two.getType().ordinal();
    }
}

