/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.graph.rel;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum RelationshipType {
    PARENT("parent"),
    BOM("bom"),
    DEPENDENCY("dependency", "dep"),
    PLUGIN("plugin"),
    PLUGIN_DEP("plugin-dependency", "plugin-dep", "plugin-level-dependency", "plugin-level-dep"),
    EXTENSION("extension", "ext");

    private final Set<String> names;

    private RelationshipType(String ... names) {
        this.names = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(names)));
    }

    public Set<String> names() {
        return this.names;
    }

    public static RelationshipType getType(String type) {
        if (type == null || type.trim().length() < 1) {
            return null;
        }
        type = type.trim();
        for (RelationshipType rt : RelationshipType.values()) {
            if (rt.name().equals(type)) {
                return rt;
            }
            for (String name : rt.names()) {
                if (!name.equalsIgnoreCase(type)) continue;
                return rt;
            }
        }
        return null;
    }
}

