/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.graph.rel;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.commonjava.atlas.maven.graph.rel.AbstractSimpleProjectRelationship;
import org.commonjava.atlas.maven.graph.rel.ExtensionRelationship;
import org.commonjava.atlas.maven.graph.rel.RelationshipConstants;
import org.commonjava.atlas.maven.graph.rel.RelationshipType;
import org.commonjava.atlas.maven.ident.ref.ArtifactRef;
import org.commonjava.atlas.maven.ident.ref.ProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleArtifactRef;
import org.commonjava.atlas.maven.ident.ref.SimpleProjectVersionRef;

public final class SimpleExtensionRelationship
extends AbstractSimpleProjectRelationship<ExtensionRelationship, ProjectVersionRef>
implements Serializable,
ExtensionRelationship {
    private static final long serialVersionUID = 1L;

    public SimpleExtensionRelationship(URI source, URI pomLocation, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean inherited) {
        super(source, pomLocation, RelationshipType.EXTENSION, declaring, target, index, inherited, false);
    }

    public SimpleExtensionRelationship(Collection<URI> sources, URI pomLocation, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean inherited) {
        super(sources, pomLocation, RelationshipType.EXTENSION, declaring, target, index, inherited, false);
    }

    public SimpleExtensionRelationship(URI source, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean inherited) {
        super(source, RelationshipConstants.POM_ROOT_URI, RelationshipType.EXTENSION, declaring, target, index, inherited, false);
    }

    public SimpleExtensionRelationship(Collection<URI> sources, ProjectVersionRef declaring, ProjectVersionRef target, int index, boolean inherited) {
        super(sources, RelationshipConstants.POM_ROOT_URI, RelationshipType.EXTENSION, declaring, target, index, inherited, false);
    }

    public SimpleExtensionRelationship(ExtensionRelationship relationship) {
        super(relationship);
    }

    public String toString() {
        return String.format("ExtensionRelationship [%s => %s (index=%s)]", this.getDeclaring(), this.getTarget(), this.getIndex());
    }

    @Override
    protected ProjectVersionRef cloneTarget(ProjectVersionRef target) {
        return new SimpleProjectVersionRef(target);
    }

    @Override
    public ArtifactRef getTargetArtifact() {
        return new SimpleArtifactRef(this.getTarget(), null, null);
    }

    @Override
    public ExtensionRelationship selectDeclaring(ProjectVersionRef ref) {
        Object t = this.getTarget();
        return new SimpleExtensionRelationship((Collection<URI>)this.getSources(), this.getPomLocation(), ref, (ProjectVersionRef)t, this.getIndex(), this.isInherited());
    }

    @Override
    public ExtensionRelationship selectTarget(ProjectVersionRef ref) {
        ProjectVersionRef d = this.getDeclaring();
        return new SimpleExtensionRelationship(this.getSources(), this.getPomLocation(), d, ref, this.getIndex(), this.isInherited());
    }

    @Override
    public ExtensionRelationship cloneFor(ProjectVersionRef declaring) {
        return new SimpleExtensionRelationship((Collection<URI>)this.getSources(), this.getPomLocation(), declaring, (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isInherited());
    }

    @Override
    public ExtensionRelationship addSource(URI source) {
        Set<URI> srcs = this.getSources();
        srcs.add(source);
        return new SimpleExtensionRelationship((Collection<URI>)srcs, this.getPomLocation(), this.getDeclaring(), (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isInherited());
    }

    @Override
    public ExtensionRelationship addSources(Collection<URI> sources) {
        Set<URI> srcs = this.getSources();
        srcs.addAll(sources);
        return new SimpleExtensionRelationship((Collection<URI>)srcs, this.getPomLocation(), this.getDeclaring(), (ProjectVersionRef)this.getTarget(), this.getIndex(), this.isInherited());
    }
}

