/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.atlas.maven.graph.rel;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.commonjava.atlas.maven.graph.rel.AbstractSimpleProjectRelationship;
import org.commonjava.atlas.maven.graph.rel.ParentRelationship;
import org.commonjava.atlas.maven.graph.rel.RelationshipConstants;
import org.commonjava.atlas.maven.graph.rel.RelationshipType;
import org.commonjava.atlas.maven.ident.ref.ArtifactRef;
import org.commonjava.atlas.maven.ident.ref.ProjectVersionRef;
import org.commonjava.atlas.maven.ident.ref.SimpleArtifactRef;
import org.commonjava.atlas.maven.ident.ref.SimpleProjectVersionRef;

public final class SimpleParentRelationship
extends AbstractSimpleProjectRelationship<ParentRelationship, ProjectVersionRef>
implements Serializable,
ParentRelationship {
    private static final long serialVersionUID = 1L;

    public SimpleParentRelationship(ProjectVersionRef declaring) {
        super(RelationshipConstants.TERMINAL_PARENT_SOURCE_URI, RelationshipType.PARENT, declaring, declaring, 0, false, false);
    }

    @Deprecated
    public SimpleParentRelationship(URI unused, ProjectVersionRef declaring) {
        super(RelationshipConstants.TERMINAL_PARENT_SOURCE_URI, RelationshipType.PARENT, declaring, declaring, 0, false, false);
    }

    public SimpleParentRelationship(URI source, ProjectVersionRef declaring, ProjectVersionRef target) {
        super(source, RelationshipType.PARENT, declaring, target, 0, false, false);
    }

    public SimpleParentRelationship(Collection<URI> sources, ProjectVersionRef declaring, ProjectVersionRef target) {
        super(sources, RelationshipType.PARENT, declaring, target, 0, false, false);
    }

    public SimpleParentRelationship(ParentRelationship relationship) {
        super(relationship);
    }

    public String toString() {
        return String.format("ParentRelationship [%s => %s]", this.getDeclaring(), this.getTarget());
    }

    @Override
    protected ProjectVersionRef cloneTarget(ProjectVersionRef target) {
        return new SimpleProjectVersionRef(target);
    }

    @Override
    public ArtifactRef getTargetArtifact() {
        return new SimpleArtifactRef(this.getTarget(), "pom", null);
    }

    @Override
    public boolean isTerminus() {
        return this.getDeclaring().equals(this.getTarget());
    }

    @Override
    public ParentRelationship selectDeclaring(ProjectVersionRef ref) {
        Object t = this.getTarget();
        return new SimpleParentRelationship((Collection<URI>)this.getSources(), ref, (ProjectVersionRef)t);
    }

    @Override
    public ParentRelationship selectTarget(ProjectVersionRef ref) {
        ProjectVersionRef d = this.getDeclaring();
        return new SimpleParentRelationship(this.getSources(), d, ref);
    }

    @Override
    public ParentRelationship cloneFor(ProjectVersionRef declaring) {
        return new SimpleParentRelationship((Collection<URI>)this.getSources(), declaring, (ProjectVersionRef)this.getTarget());
    }

    @Override
    public ParentRelationship addSource(URI source) {
        Set<URI> srcs = this.getSources();
        srcs.add(source);
        return new SimpleParentRelationship((Collection<URI>)srcs, this.getDeclaring(), (ProjectVersionRef)this.getTarget());
    }

    @Override
    public ParentRelationship addSources(Collection<URI> sources) {
        Set<URI> srcs = this.getSources();
        srcs.addAll(sources);
        return new SimpleParentRelationship((Collection<URI>)srcs, this.getDeclaring(), (ProjectVersionRef)this.getTarget());
    }
}

