/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io.jdom;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.io.util.AbstractJDOMWriter;
import org.apache.maven.io.util.IndentationCounter;
import org.apache.maven.io.util.WriterUtils;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.UncheckedJDOMFactory;

public class MetadataJDOMWriter
extends AbstractJDOMWriter<Metadata, MetadataJDOMWriter> {
    private static final String INDENT = "  ";
    private final JDOMFactory factory = new UncheckedJDOMFactory();
    private final String lineSeparator;

    public MetadataJDOMWriter() {
        this.lineSeparator = "\n";
    }

    protected void iteratePlugin(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Plugin value = (Plugin)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePlugin(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateSnapshotVersion(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                SnapshotVersion value = (SnapshotVersion)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateSnapshotVersion(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void updateMetadata(Metadata metadata, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", metadata.getGroupId() == null ? null : metadata.getGroupId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", metadata.getArtifactId() == null ? null : metadata.getArtifactId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", metadata.getVersion() == null ? null : metadata.getVersion(), null);
        this.updateVersioning(metadata.getVersioning(), "versioning", innerCount, root);
        this.iteratePlugin(innerCount, root, metadata.getPlugins(), "plugins", "plugin");
    }

    protected void updatePlugin(Plugin plugin, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", plugin.getName() == null ? null : plugin.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "prefix", plugin.getPrefix() == null ? null : plugin.getPrefix(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", plugin.getArtifactId() == null ? null : plugin.getArtifactId(), null);
    }

    protected void updateSnapshot(Snapshot snapshot, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = snapshot != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "timestamp", snapshot.getTimestamp() == null ? null : snapshot.getTimestamp(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "buildNumber", snapshot.getBuildNumber() == 0 ? null : String.valueOf(snapshot.getBuildNumber()), "0");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "localCopy", !snapshot.isLocalCopy() ? null : String.valueOf(snapshot.isLocalCopy()), "false");
        }
    }

    protected void updateSnapshotVersion(SnapshotVersion snapshotVersion, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "classifier", snapshotVersion.getClassifier() == null ? null : snapshotVersion.getClassifier(), "");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "extension", snapshotVersion.getExtension() == null ? null : snapshotVersion.getExtension(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "value", snapshotVersion.getVersion() == null ? null : snapshotVersion.getVersion(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "updated", snapshotVersion.getUpdated() == null ? null : snapshotVersion.getUpdated(), null);
    }

    protected void updateVersioning(Versioning versioning, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = versioning != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "latest", versioning.getLatest() == null ? null : versioning.getLatest(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "release", versioning.getRelease() == null ? null : versioning.getRelease(), null);
            this.updateSnapshot(versioning.getSnapshot(), "snapshot", innerCount, root);
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, versioning.getVersions(), "versions", "version");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "lastUpdated", versioning.getLastUpdated() == null ? null : versioning.getLastUpdated(), null);
            this.iterateSnapshotVersion(innerCount, root, versioning.getSnapshotVersions(), "snapshotVersions", "snapshotVersion");
        }
    }

    @Override
    protected void update(Metadata source, IndentationCounter indentationCounter, Element rootElement) throws IOException {
        this.updateMetadata(source, "metadata", indentationCounter, rootElement);
    }
}

