/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.jdom;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.io.util.AbstractJDOMWriter;
import org.apache.maven.io.util.IndentationCounter;
import org.apache.maven.io.util.WriterUtils;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom2.Element;

public class MavenJDOMWriter
extends AbstractJDOMWriter<Model, MavenJDOMWriter> {
    public MavenJDOMWriter() {
    }

    public MavenJDOMWriter(String encoding) {
        super(encoding);
    }

    public MavenJDOMWriter(Model model) {
        super(model.getModelEncoding() == null ? "UTF-8" : model.getModelEncoding());
    }

    protected void iterateContributor(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Contributor value = (Contributor)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateContributor(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateDependency(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Dependency value = (Dependency)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDependency(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateDeveloper(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Developer value = (Developer)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDeveloper(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateExclusion(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Exclusion value = (Exclusion)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExclusion(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateExtension(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Extension value = (Extension)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExtension(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateLicense(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                License value = (License)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateLicense(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateMailingList(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                MailingList value = (MailingList)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateMailingList(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateNotifier(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Notifier value = (Notifier)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateNotifier(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iteratePlugin(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Plugin value = (Plugin)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePlugin(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iteratePluginExecution(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                PluginExecution value = (PluginExecution)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePluginExecution(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateProfile(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Profile value = (Profile)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateReportPlugin(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportPlugin value = (ReportPlugin)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportPlugin(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateReportSet(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportSet value = (ReportSet)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportSet(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateRepository(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Repository value = (Repository)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateResource(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Resource value = (Resource)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateResource(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void updateActivation(Activation activation, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activation != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "activeByDefault", !activation.isActiveByDefault() ? null : String.valueOf(activation.isActiveByDefault()), "false");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "jdk", activation.getJdk() == null ? null : activation.getJdk(), null);
            this.updateActivationOS(activation.getOs(), "os", innerCount, root);
            this.updateActivationProperty(activation.getProperty(), "property", innerCount, root);
            this.updateActivationFile(activation.getFile(), "file", innerCount, root);
        }
    }

    protected void updateActivationFile(ActivationFile activationFile, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activationFile != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "missing", activationFile.getMissing() == null ? null : activationFile.getMissing(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "exists", activationFile.getExists() == null ? null : activationFile.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS activationOS, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activationOS != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", activationOS.getName() == null ? null : activationOS.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "family", activationOS.getFamily() == null ? null : activationOS.getFamily(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "arch", activationOS.getArch() == null ? null : activationOS.getArch(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", activationOS.getVersion() == null ? null : activationOS.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty activationProperty, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activationProperty != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", activationProperty.getName() == null ? null : activationProperty.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "value", activationProperty.getValue() == null ? null : activationProperty.getValue(), null);
        }
    }

    protected void updateBuild(Build build, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = build != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "sourceDirectory", build.getSourceDirectory() == null ? null : build.getSourceDirectory(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "scriptSourceDirectory", build.getScriptSourceDirectory() == null ? null : build.getScriptSourceDirectory(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "testSourceDirectory", build.getTestSourceDirectory() == null ? null : build.getTestSourceDirectory(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", build.getOutputDirectory() == null ? null : build.getOutputDirectory(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "testOutputDirectory", build.getTestOutputDirectory() == null ? null : build.getTestOutputDirectory(), null);
            this.iterateExtension(innerCount, root, build.getExtensions(), "extensions", "extension");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", build.getDefaultGoal() == null ? null : build.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, build.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, build.getTestResources(), "testResources", "testResource");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "directory", build.getDirectory() == null ? null : build.getDirectory(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "finalName", build.getFinalName() == null ? null : build.getFinalName(), null);
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, build.getFilters(), "filters", "filter");
            this.updatePluginManagement(build.getPluginManagement(), "pluginManagement", innerCount, root);
            this.iteratePlugin(innerCount, root, build.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateBuildBase(BuildBase buildBase, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = buildBase != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", buildBase.getDefaultGoal() == null ? null : buildBase.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, buildBase.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, buildBase.getTestResources(), "testResources", "testResource");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "directory", buildBase.getDirectory() == null ? null : buildBase.getDirectory(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "finalName", buildBase.getFinalName() == null ? null : buildBase.getFinalName(), null);
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, buildBase.getFilters(), "filters", "filter");
            this.updatePluginManagement(buildBase.getPluginManagement(), "pluginManagement", innerCount, root);
            this.iteratePlugin(innerCount, root, buildBase.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateCiManagement(CiManagement ciManagement, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = ciManagement != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "system", ciManagement.getSystem() == null ? null : ciManagement.getSystem(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", ciManagement.getUrl() == null ? null : ciManagement.getUrl(), null);
            this.iterateNotifier(innerCount, root, ciManagement.getNotifiers(), "notifiers", "notifier");
        }
    }

    protected void updateConfigurationContainer(ConfigurationContainer configurationContainer, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = configurationContainer != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "inherited", configurationContainer.getInherited() == null ? null : configurationContainer.getInherited(), null);
            WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)configurationContainer.getConfiguration());
        }
    }

    protected void updateContributor(Contributor contributor, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", contributor.getName() == null ? null : contributor.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "email", contributor.getEmail() == null ? null : contributor.getEmail(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", contributor.getUrl() == null ? null : contributor.getUrl(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "organization", contributor.getOrganization() == null ? null : contributor.getOrganization(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", contributor.getOrganizationUrl() == null ? null : contributor.getOrganizationUrl(), null);
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, contributor.getRoles(), "roles", "role");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "timezone", contributor.getTimezone() == null ? null : contributor.getTimezone(), null);
        WriterUtils.findAndReplaceProperties(innerCount, root, "properties", contributor.getProperties());
    }

    protected void updateDependency(Dependency dependency, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", dependency.getGroupId() == null ? null : dependency.getGroupId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", dependency.getArtifactId() == null ? null : dependency.getArtifactId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", dependency.getVersion() == null ? null : dependency.getVersion(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "type", dependency.getType() == null ? null : dependency.getType(), "jar");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "classifier", dependency.getClassifier() == null ? null : dependency.getClassifier(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "scope", dependency.getScope() == null ? null : dependency.getScope(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "systemPath", dependency.getSystemPath() == null ? null : dependency.getSystemPath(), null);
        this.iterateExclusion(innerCount, root, dependency.getExclusions(), "exclusions", "exclusion");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "optional", dependency.getOptional() == null ? null : dependency.getOptional(), null);
    }

    protected void updateDependencyManagement(DependencyManagement dependencyManagement, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = dependencyManagement != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.iterateDependency(innerCount, root, dependencyManagement.getDependencies(), "dependencies", "dependency");
        }
    }

    protected void updateDeploymentRepository(DeploymentRepository deploymentRepository, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = deploymentRepository != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "uniqueVersion", deploymentRepository.isUniqueVersion() ? null : String.valueOf(deploymentRepository.isUniqueVersion()), "true");
            this.updateRepositoryPolicy(deploymentRepository.getReleases(), "releases", innerCount, root);
            this.updateRepositoryPolicy(deploymentRepository.getSnapshots(), "snapshots", innerCount, root);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", deploymentRepository.getId() == null ? null : deploymentRepository.getId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", deploymentRepository.getName() == null ? null : deploymentRepository.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", deploymentRepository.getUrl() == null ? null : deploymentRepository.getUrl(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "layout", deploymentRepository.getLayout() == null ? null : deploymentRepository.getLayout(), "default");
        }
    }

    protected void updateDeveloper(Developer developer, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", developer.getId() == null ? null : developer.getId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", developer.getName() == null ? null : developer.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "email", developer.getEmail() == null ? null : developer.getEmail(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", developer.getUrl() == null ? null : developer.getUrl(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "organization", developer.getOrganization() == null ? null : developer.getOrganization(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", developer.getOrganizationUrl() == null ? null : developer.getOrganizationUrl(), null);
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, developer.getRoles(), "roles", "role");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "timezone", developer.getTimezone() == null ? null : developer.getTimezone(), null);
        WriterUtils.findAndReplaceProperties(innerCount, root, "properties", developer.getProperties());
    }

    protected void updateDistributionManagement(DistributionManagement distributionManagement, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = distributionManagement != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.updateDeploymentRepository(distributionManagement.getRepository(), "repository", innerCount, root);
            this.updateDeploymentRepository(distributionManagement.getSnapshotRepository(), "snapshotRepository", innerCount, root);
            this.updateSite(distributionManagement.getSite(), "site", innerCount, root);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "downloadUrl", distributionManagement.getDownloadUrl() == null ? null : distributionManagement.getDownloadUrl(), null);
            this.updateRelocation(distributionManagement.getRelocation(), "relocation", innerCount, root);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "status", distributionManagement.getStatus() == null ? null : distributionManagement.getStatus(), null);
        }
    }

    protected void updateExclusion(Exclusion exclusion, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", exclusion.getArtifactId() == null ? null : exclusion.getArtifactId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", exclusion.getGroupId() == null ? null : exclusion.getGroupId(), null);
    }

    protected void updateExtension(Extension extension, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", extension.getGroupId() == null ? null : extension.getGroupId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", extension.getArtifactId() == null ? null : extension.getArtifactId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", extension.getVersion() == null ? null : extension.getVersion(), null);
    }

    protected void updateFileSet(FileSet fileSet, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = fileSet != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "directory", fileSet.getDirectory() == null ? null : fileSet.getDirectory(), null);
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, fileSet.getIncludes(), "includes", "include");
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, fileSet.getExcludes(), "excludes", "exclude");
        }
    }

    protected void updateIssueManagement(IssueManagement issueManagement, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = issueManagement != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "system", issueManagement.getSystem() == null ? null : issueManagement.getSystem(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", issueManagement.getUrl() == null ? null : issueManagement.getUrl(), null);
        }
    }

    protected void updateLicense(License license, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", license.getName() == null ? null : license.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", license.getUrl() == null ? null : license.getUrl(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "distribution", license.getDistribution() == null ? null : license.getDistribution(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "comments", license.getComments() == null ? null : license.getComments(), null);
    }

    protected void updateMailingList(MailingList mailingList, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", mailingList.getName() == null ? null : mailingList.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "subscribe", mailingList.getSubscribe() == null ? null : mailingList.getSubscribe(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "unsubscribe", mailingList.getUnsubscribe() == null ? null : mailingList.getUnsubscribe(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "post", mailingList.getPost() == null ? null : mailingList.getPost(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "archive", mailingList.getArchive() == null ? null : mailingList.getArchive(), null);
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, mailingList.getOtherArchives(), "otherArchives", "otherArchive");
    }

    protected void updateModel(Model model, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "modelVersion", model.getModelVersion() == null ? null : model.getModelVersion(), null);
        this.updateParent(model.getParent(), "parent", innerCount, root);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", model.getGroupId() == null ? null : model.getGroupId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", model.getArtifactId() == null ? null : model.getArtifactId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", model.getVersion() == null ? null : model.getVersion(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "packaging", model.getPackaging() == null ? null : model.getPackaging(), "jar");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", model.getName() == null ? null : model.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "description", model.getDescription() == null ? null : model.getDescription(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", model.getUrl() == null ? null : model.getUrl(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "inceptionYear", model.getInceptionYear() == null ? null : model.getInceptionYear(), null);
        this.updateOrganization(model.getOrganization(), "organization", innerCount, root);
        this.iterateLicense(innerCount, root, model.getLicenses(), "licenses", "license");
        this.iterateDeveloper(innerCount, root, model.getDevelopers(), "developers", "developer");
        this.iterateContributor(innerCount, root, model.getContributors(), "contributors", "contributor");
        this.iterateMailingList(innerCount, root, model.getMailingLists(), "mailingLists", "mailingList");
        this.updatePrerequisites(model.getPrerequisites(), "prerequisites", innerCount, root);
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, model.getModules(), "modules", "module");
        this.updateScm(model.getScm(), "scm", innerCount, root);
        this.updateIssueManagement(model.getIssueManagement(), "issueManagement", innerCount, root);
        this.updateCiManagement(model.getCiManagement(), "ciManagement", innerCount, root);
        this.updateDistributionManagement(model.getDistributionManagement(), "distributionManagement", innerCount, root);
        WriterUtils.findAndReplaceProperties(innerCount, root, "properties", model.getProperties());
        this.updateDependencyManagement(model.getDependencyManagement(), "dependencyManagement", innerCount, root);
        this.iterateDependency(innerCount, root, model.getDependencies(), "dependencies", "dependency");
        this.iterateRepository(innerCount, root, model.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, model.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.updateBuild(model.getBuild(), "build", innerCount, root);
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)model.getReports());
        this.updateReporting(model.getReporting(), "reporting", innerCount, root);
        this.iterateProfile(innerCount, root, model.getProfiles(), "profiles", "profile");
    }

    protected void updateModelBase(ModelBase modelBase, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = modelBase != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, modelBase.getModules(), "modules", "module");
            this.updateDistributionManagement(modelBase.getDistributionManagement(), "distributionManagement", innerCount, root);
            WriterUtils.findAndReplaceProperties(innerCount, root, "properties", modelBase.getProperties());
            this.updateDependencyManagement(modelBase.getDependencyManagement(), "dependencyManagement", innerCount, root);
            this.iterateDependency(innerCount, root, modelBase.getDependencies(), "dependencies", "dependency");
            this.iterateRepository(innerCount, root, modelBase.getRepositories(), "repositories", "repository");
            this.iterateRepository(innerCount, root, modelBase.getPluginRepositories(), "pluginRepositories", "pluginRepository");
            WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)modelBase.getReports());
            this.updateReporting(modelBase.getReporting(), "reporting", innerCount, root);
        }
    }

    protected void updateNotifier(Notifier notifier, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "type", notifier.getType() == null ? null : notifier.getType(), "mail");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "sendOnError", notifier.isSendOnError() ? null : String.valueOf(notifier.isSendOnError()), "true");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "sendOnFailure", notifier.isSendOnFailure() ? null : String.valueOf(notifier.isSendOnFailure()), "true");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "sendOnSuccess", notifier.isSendOnSuccess() ? null : String.valueOf(notifier.isSendOnSuccess()), "true");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "sendOnWarning", notifier.isSendOnWarning() ? null : String.valueOf(notifier.isSendOnWarning()), "true");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "address", notifier.getAddress() == null ? null : notifier.getAddress(), null);
        WriterUtils.findAndReplaceProperties(innerCount, root, "configuration", notifier.getConfiguration());
    }

    protected void updateOrganization(Organization organization, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = organization != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", organization.getName() == null ? null : organization.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", organization.getUrl() == null ? null : organization.getUrl(), null);
        }
    }

    protected void updateParent(Parent parent, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = parent != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", parent.getArtifactId() == null ? null : parent.getArtifactId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", parent.getGroupId() == null ? null : parent.getGroupId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", parent.getVersion() == null ? null : parent.getVersion(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "relativePath", parent.getRelativePath() == null ? null : parent.getRelativePath(), "../pom.xml");
        }
    }

    protected void updatePlugin(Plugin plugin, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", plugin.getGroupId() == null ? null : plugin.getGroupId(), "org.apache.maven.plugins");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", plugin.getArtifactId() == null ? null : plugin.getArtifactId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", plugin.getVersion() == null ? null : plugin.getVersion(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "extensions", plugin.getExtensions() == null ? null : plugin.getExtensions(), null);
        this.iteratePluginExecution(innerCount, root, plugin.getExecutions(), "executions", "execution");
        this.iterateDependency(innerCount, root, plugin.getDependencies(), "dependencies", "dependency");
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "goals", (Xpp3Dom)plugin.getGoals());
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "inherited", plugin.getInherited() == null ? null : plugin.getInherited(), null);
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)plugin.getConfiguration());
    }

    protected void updatePluginConfiguration(PluginConfiguration pluginConfiguration, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = pluginConfiguration != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.updatePluginManagement(pluginConfiguration.getPluginManagement(), "pluginManagement", innerCount, root);
            this.iteratePlugin(innerCount, root, pluginConfiguration.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePluginContainer(PluginContainer pluginContainer, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = pluginContainer != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.iteratePlugin(innerCount, root, pluginContainer.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePluginExecution(PluginExecution pluginExecution, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", pluginExecution.getId() == null ? null : pluginExecution.getId(), "default");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "phase", pluginExecution.getPhase() == null ? null : pluginExecution.getPhase(), null);
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, pluginExecution.getGoals(), "goals", "goal");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "inherited", pluginExecution.getInherited() == null ? null : pluginExecution.getInherited(), null);
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)pluginExecution.getConfiguration());
    }

    protected void updatePluginManagement(PluginManagement pluginManagement, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = pluginManagement != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            this.iteratePlugin(innerCount, root, pluginManagement.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updatePrerequisites(Prerequisites prerequisites, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = prerequisites != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "maven", prerequisites.getMaven() == null ? null : prerequisites.getMaven(), "2.0");
        }
    }

    protected void updateProfile(Profile profile, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", profile.getId() == null ? null : profile.getId(), "default");
        this.updateActivation(profile.getActivation(), "activation", innerCount, root);
        this.updateBuildBase(profile.getBuild(), "build", innerCount, root);
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, profile.getModules(), "modules", "module");
        this.updateDistributionManagement(profile.getDistributionManagement(), "distributionManagement", innerCount, root);
        WriterUtils.findAndReplaceProperties(innerCount, root, "properties", profile.getProperties());
        this.updateDependencyManagement(profile.getDependencyManagement(), "dependencyManagement", innerCount, root);
        this.iterateDependency(innerCount, root, profile.getDependencies(), "dependencies", "dependency");
        this.iterateRepository(innerCount, root, profile.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, profile.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)profile.getReports());
        this.updateReporting(profile.getReporting(), "reporting", innerCount, root);
    }

    protected void updateRelocation(Relocation relocation, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = relocation != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", relocation.getGroupId() == null ? null : relocation.getGroupId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", relocation.getArtifactId() == null ? null : relocation.getArtifactId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", relocation.getVersion() == null ? null : relocation.getVersion(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "message", relocation.getMessage() == null ? null : relocation.getMessage(), null);
        }
    }

    protected void updateReportPlugin(ReportPlugin reportPlugin, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "groupId", reportPlugin.getGroupId() == null ? null : reportPlugin.getGroupId(), "org.apache.maven.plugins");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "artifactId", reportPlugin.getArtifactId() == null ? null : reportPlugin.getArtifactId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", reportPlugin.getVersion() == null ? null : reportPlugin.getVersion(), null);
        this.iterateReportSet(innerCount, root, reportPlugin.getReportSets(), "reportSets", "reportSet");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "inherited", reportPlugin.getInherited() == null ? null : reportPlugin.getInherited(), null);
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)reportPlugin.getConfiguration());
    }

    protected void updateReportSet(ReportSet reportSet, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", reportSet.getId() == null ? null : reportSet.getId(), "default");
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, reportSet.getReports(), "reports", "report");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "inherited", reportSet.getInherited() == null ? null : reportSet.getInherited(), null);
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)reportSet.getConfiguration());
    }

    protected void updateReporting(Reporting reporting, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = reporting != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "excludeDefaults", reporting.getExcludeDefaults() == null ? null : reporting.getExcludeDefaults(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", reporting.getOutputDirectory() == null ? null : reporting.getOutputDirectory(), null);
            this.iterateReportPlugin(innerCount, root, reporting.getPlugins(), "plugins", "plugin");
        }
    }

    protected void updateRepository(Repository repository, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(repository.getReleases(), "releases", innerCount, root);
        this.updateRepositoryPolicy(repository.getSnapshots(), "snapshots", innerCount, root);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", repository.getId() == null ? null : repository.getId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", repository.getName() == null ? null : repository.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", repository.getUrl() == null ? null : repository.getUrl(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "layout", repository.getLayout() == null ? null : repository.getLayout(), "default");
    }

    protected void updateRepositoryBase(RepositoryBase repositoryBase, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = repositoryBase != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", repositoryBase.getId() == null ? null : repositoryBase.getId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", repositoryBase.getName() == null ? null : repositoryBase.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", repositoryBase.getUrl() == null ? null : repositoryBase.getUrl(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "layout", repositoryBase.getLayout() == null ? null : repositoryBase.getLayout(), "default");
        }
    }

    protected void updateRepositoryPolicy(RepositoryPolicy repositoryPolicy, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = repositoryPolicy != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "enabled", repositoryPolicy.getEnabled() == null ? null : repositoryPolicy.getEnabled(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", repositoryPolicy.getUpdatePolicy() == null ? null : repositoryPolicy.getUpdatePolicy(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", repositoryPolicy.getChecksumPolicy() == null ? null : repositoryPolicy.getChecksumPolicy(), null);
        }
    }

    protected void updateResource(Resource resource, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "targetPath", resource.getTargetPath() == null ? null : resource.getTargetPath(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "filtering", resource.getFiltering() == null ? null : resource.getFiltering(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "directory", resource.getDirectory() == null ? null : resource.getDirectory(), null);
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, resource.getIncludes(), "includes", "include");
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, resource.getExcludes(), "excludes", "exclude");
    }

    protected void updateScm(Scm scm, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = scm != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "connection", scm.getConnection() == null ? null : scm.getConnection(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "developerConnection", scm.getDeveloperConnection() == null ? null : scm.getDeveloperConnection(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "tag", scm.getTag() == null ? null : scm.getTag(), "HEAD");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", scm.getUrl() == null ? null : scm.getUrl(), null);
        }
    }

    protected void updateSite(Site site, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = site != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", site.getId() == null ? null : site.getId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", site.getName() == null ? null : site.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", site.getUrl() == null ? null : site.getUrl(), null);
        }
    }

    @Override
    protected void update(Model source, IndentationCounter indentationCounter, Element rootElement) throws IOException {
        this.updateModel(source, "project", indentationCounter, rootElement);
    }
}

