/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.jdom;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.io.util.AbstractJDOMWriter;
import org.apache.maven.io.util.IndentationCounter;
import org.apache.maven.io.util.WriterUtils;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryBase;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.UncheckedJDOMFactory;

public class SettingsJDOMWriter
extends AbstractJDOMWriter<Settings, SettingsJDOMWriter> {
    private static final String INDENT = "  ";
    private final JDOMFactory factory = new UncheckedJDOMFactory();
    private final String lineSeparator;

    public SettingsJDOMWriter() {
        this.lineSeparator = "\n";
    }

    protected void iterateMirror(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Mirror value = (Mirror)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateMirror(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateProfile(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Profile value = (Profile)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateProxy(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Proxy value = (Proxy)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProxy(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateRepository(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Repository value = (Repository)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateServer(IndentationCounter counter, Element parent, Collection list, String parentTag, String childTag) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Server value = (Server)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = (Element)elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateServer(value, childTag, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void updateActivation(Activation activation, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activation != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "activeByDefault", !activation.isActiveByDefault() ? null : String.valueOf(activation.isActiveByDefault()), "false");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "jdk", activation.getJdk() == null ? null : activation.getJdk(), null);
            this.updateActivationOS(activation.getOs(), "os", innerCount, root);
            this.updateActivationProperty(activation.getProperty(), "property", innerCount, root);
            this.updateActivationFile(activation.getFile(), "file", innerCount, root);
        }
    }

    protected void updateActivationFile(ActivationFile activationFile, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activationFile != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "missing", activationFile.getMissing() == null ? null : activationFile.getMissing(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "exists", activationFile.getExists() == null ? null : activationFile.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS activationOS, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activationOS != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", activationOS.getName() == null ? null : activationOS.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "family", activationOS.getFamily() == null ? null : activationOS.getFamily(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "arch", activationOS.getArch() == null ? null : activationOS.getArch(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "version", activationOS.getVersion() == null ? null : activationOS.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty activationProperty, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = activationProperty != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", activationProperty.getName() == null ? null : activationProperty.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "value", activationProperty.getValue() == null ? null : activationProperty.getValue(), null);
        }
    }

    protected void updateIdentifiableBase(IdentifiableBase identifiableBase, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = identifiableBase != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", identifiableBase.getId() == null ? null : identifiableBase.getId(), "default");
        }
    }

    protected void updateMirror(Mirror mirror, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "mirrorOf", mirror.getMirrorOf() == null ? null : mirror.getMirrorOf(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", mirror.getName() == null ? null : mirror.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", mirror.getUrl() == null ? null : mirror.getUrl(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "layout", mirror.getLayout() == null ? null : mirror.getLayout(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "mirrorOfLayouts", mirror.getMirrorOfLayouts() == null ? null : mirror.getMirrorOfLayouts(), "default,legacy");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", mirror.getId() == null ? null : mirror.getId(), "default");
    }

    protected void updateProfile(Profile profile, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        this.updateActivation(profile.getActivation(), "activation", innerCount, root);
        WriterUtils.findAndReplaceProperties(innerCount, root, "properties", profile.getProperties());
        this.iterateRepository(innerCount, root, profile.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, profile.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", profile.getId() == null ? null : profile.getId(), "default");
    }

    protected void updateProxy(Proxy proxy, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "active", proxy.isActive() ? null : String.valueOf(proxy.isActive()), "true");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "protocol", proxy.getProtocol() == null ? null : proxy.getProtocol(), "http");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "username", proxy.getUsername() == null ? null : proxy.getUsername(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "password", proxy.getPassword() == null ? null : proxy.getPassword(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "port", proxy.getPort() == 8080 ? null : String.valueOf(proxy.getPort()), "8080");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "host", proxy.getHost() == null ? null : proxy.getHost(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "nonProxyHosts", proxy.getNonProxyHosts() == null ? null : proxy.getNonProxyHosts(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", proxy.getId() == null ? null : proxy.getId(), "default");
    }

    protected void updateRepository(Repository repository, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(repository.getReleases(), "releases", innerCount, root);
        this.updateRepositoryPolicy(repository.getSnapshots(), "snapshots", innerCount, root);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", repository.getId() == null ? null : repository.getId(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", repository.getName() == null ? null : repository.getName(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", repository.getUrl() == null ? null : repository.getUrl(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "layout", repository.getLayout() == null ? null : repository.getLayout(), "default");
    }

    protected void updateRepositoryBase(RepositoryBase repositoryBase, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = repositoryBase != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", repositoryBase.getId() == null ? null : repositoryBase.getId(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "name", repositoryBase.getName() == null ? null : repositoryBase.getName(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "url", repositoryBase.getUrl() == null ? null : repositoryBase.getUrl(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "layout", repositoryBase.getLayout() == null ? null : repositoryBase.getLayout(), "default");
        }
    }

    protected void updateRepositoryPolicy(RepositoryPolicy repositoryPolicy, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = repositoryPolicy != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "enabled", repositoryPolicy.isEnabled() ? null : String.valueOf(repositoryPolicy.isEnabled()), "true");
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", repositoryPolicy.getUpdatePolicy() == null ? null : repositoryPolicy.getUpdatePolicy(), null);
            WriterUtils.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", repositoryPolicy.getChecksumPolicy() == null ? null : repositoryPolicy.getChecksumPolicy(), null);
        }
    }

    protected void updateServer(Server server, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "username", server.getUsername() == null ? null : server.getUsername(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "password", server.getPassword() == null ? null : server.getPassword(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "privateKey", server.getPrivateKey() == null ? null : server.getPrivateKey(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "passphrase", server.getPassphrase() == null ? null : server.getPassphrase(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "filePermissions", server.getFilePermissions() == null ? null : server.getFilePermissions(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "directoryPermissions", server.getDirectoryPermissions() == null ? null : server.getDirectoryPermissions(), null);
        WriterUtils.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)server.getConfiguration());
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "id", server.getId() == null ? null : server.getId(), "default");
    }

    protected void updateSettings(Settings settings, String xmlTag, IndentationCounter counter, Element element) {
        Element root = element;
        IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "localRepository", settings.getLocalRepository() == null ? null : settings.getLocalRepository(), null);
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "interactiveMode", settings.isInteractiveMode() ? null : String.valueOf(settings.isInteractiveMode()), "true");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "usePluginRegistry", !settings.isUsePluginRegistry() ? null : String.valueOf(settings.isUsePluginRegistry()), "false");
        WriterUtils.findAndReplaceSimpleElement(innerCount, root, "offline", !settings.isOffline() ? null : String.valueOf(settings.isOffline()), "false");
        this.iterateProxy(innerCount, root, settings.getProxies(), "proxies", "proxy");
        this.iterateServer(innerCount, root, settings.getServers(), "servers", "server");
        this.iterateMirror(innerCount, root, settings.getMirrors(), "mirrors", "mirror");
        this.iterateProfile(innerCount, root, settings.getProfiles(), "profiles", "profile");
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, settings.getActiveProfiles(), "activeProfiles", "activeProfile");
        WriterUtils.findAndReplaceSimpleLists(innerCount, root, settings.getPluginGroups(), "pluginGroups", "pluginGroup");
    }

    protected void updateTrackableBase(TrackableBase trackableBase, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = trackableBase != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter indentationCounter = new IndentationCounter(counter.getDepth() + 1);
        }
    }

    @Override
    protected void update(Settings source, IndentationCounter indentationCounter, Element rootElement) throws IOException {
        this.updateSettings(source, "settings", indentationCounter, rootElement);
    }
}

