/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.annotations.config.binding.AnnotationsMappingBinding;
import org.compass.annotations.config.binding.OverrideAnnotationsWithJsonCpmMappingBinding;
import org.compass.annotations.config.binding.OverrideAnnotationsWithXmlCpmMappingBinding;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.config.CompassMappingBinding;
import org.compass.core.config.CompassMappingProcessor;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.config.binding.JsonMetaDataBinding;
import org.compass.core.config.binding.JsonPlainMappingBinding;
import org.compass.core.config.binding.XmlMetaDataBinding;
import org.compass.core.config.binding.XmlPlainMappingBinding;
import org.compass.core.config.binding.scanner.Filter;
import org.compass.core.config.binding.scanner.ScanItem;
import org.compass.core.config.binding.scanner.Scanner;
import org.compass.core.config.binding.scanner.ScannerFactoy;
import org.compass.core.config.builder.ConfigurationBuilder;
import org.compass.core.config.builder.SmartConfigurationBuilder;
import org.compass.core.converter.Converter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.DefaultConverterLookup;
import org.compass.core.engine.naming.DefaultPropertyNamingStrategyFactory;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.executor.DefaultExecutorManager;
import org.compass.core.impl.DefaultCompass;
import org.compass.core.impl.RefreshableCompass;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.internal.DefaultCompassMapping;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.metadata.impl.DefaultCompassMetaData;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.matcher.AntPathMatcher;

public class CompassConfiguration {
    protected static final Log log = LogFactory.getLog(CompassConfiguration.class);
    private CompassMetaData metaData;
    private InternalCompassMapping mapping;
    private CompassSettings settings;
    private ClassLoader classLoader;
    protected CompassMappingBinding mappingBinding;
    protected ConfigurationBuilder configurationBuilder = new SmartConfigurationBuilder();
    private HashMap<String, ConverterHolder> temporaryConvertersByName = new HashMap();

    public CompassConfiguration() {
        this.mapping = new DefaultCompassMapping();
        this.metaData = new DefaultCompassMetaData();
        this.settings = new CompassSettings();
    }

    private CompassMappingBinding getMappingBinding() {
        if (this.mappingBinding == null) {
            this.mappingBinding = new CompassMappingBinding();
            this.addMappingBindings(this.mappingBinding);
            this.mappingBinding.setUpBinding(this.mapping, this.metaData, this.settings);
        }
        return this.mappingBinding;
    }

    protected void addMappingBindings(CompassMappingBinding mappingBinding) {
        mappingBinding.addMappingBinding(new XmlMetaDataBinding());
        mappingBinding.addMappingBinding(new JsonMetaDataBinding());
        mappingBinding.addMappingBinding(new XmlPlainMappingBinding());
        mappingBinding.addMappingBinding(new JsonPlainMappingBinding());
        mappingBinding.addMappingBinding(new AnnotationsMappingBinding());
        mappingBinding.addMappingBinding(new OverrideAnnotationsWithXmlCpmMappingBinding());
        mappingBinding.addMappingBinding(new OverrideAnnotationsWithJsonCpmMappingBinding());
    }

    public CompassConfiguration setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.settings.setClassLoader(classLoader);
        return this;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public CompassSettings getSettings() {
        return this.settings;
    }

    public CompassConfiguration setSetting(String setting, Object value) {
        this.settings.setObjectSetting(setting, value);
        return this;
    }

    public CompassConfiguration setConnection(String connection) {
        this.settings.setSetting("compass.engine.connection", connection);
        return this;
    }

    public CompassConfiguration registerConverter(String converterName, Converter converter) {
        this.temporaryConvertersByName.put(converterName, new ConverterHolder(converter));
        return this;
    }

    public CompassConfiguration registerConverter(String converterName, Class type, Converter converter) {
        this.temporaryConvertersByName.put(converterName, new ConverterHolder(type, converter));
        return this;
    }

    public Compass buildCompass() throws CompassException {
        CompassSettings copySettings = this.settings.copy();
        copySettings.setClassLoader(this.getClassLoader());
        for (String setting : this.settings.keySet()) {
            if (!setting.startsWith("compass.mapping")) continue;
            String mapping = this.settings.getSetting(setting);
            if (mapping.endsWith("cpm.xml") || mapping.endsWith("cmd.xml")) {
                this.addResource(mapping);
            } else {
                try {
                    this.addClass(ClassUtils.forName(mapping, copySettings.getClassLoader()));
                }
                catch (ClassNotFoundException e) {
                    throw new CompassException("Failed to find class [" + mapping + "]");
                }
            }
            this.settings.removeSetting(setting);
        }
        Map<String, CompassSettings> scanGroups = this.settings.getSettingGroups("compass.mapping.scan");
        for (Map.Entry<String, CompassSettings> entry : scanGroups.entrySet()) {
            String packageSetting = entry.getValue().getSetting("package");
            if (packageSetting == null) {
                throw new ConfigurationException("[package] must be set when scanning for [" + entry.getKey() + "] scan");
            }
            this.addScan(packageSetting, entry.getValue().getSetting("pattern"));
        }
        DefaultConverterLookup converterLookup = new DefaultConverterLookup();
        this.registerExtraConverters(converterLookup);
        converterLookup.configure(copySettings);
        for (String converterName : this.temporaryConvertersByName.keySet()) {
            ConverterHolder converterHolder = this.temporaryConvertersByName.get(converterName);
            if (converterHolder.type == null) {
                converterLookup.registerConverter(converterName, converterHolder.converter);
                continue;
            }
            converterLookup.registerConverter(converterName, converterHolder.converter, converterHolder.type);
        }
        InternalCompassMapping copyCompassMapping = this.mapping.copy(converterLookup);
        DefaultPropertyNamingStrategyFactory propertyNamingStrategyFactory = new DefaultPropertyNamingStrategyFactory();
        PropertyNamingStrategy propertyNamingStrategy = propertyNamingStrategyFactory.createNamingStrategy(copySettings);
        CompassMappingProcessor mappingProcessor = new CompassMappingProcessor();
        mappingProcessor.process(copyCompassMapping, propertyNamingStrategy, converterLookup, copySettings);
        CompassMetaData copyMetaData = this.metaData.copy();
        DefaultExecutorManager executorManager = new DefaultExecutorManager();
        executorManager.configure(this.settings);
        return new RefreshableCompass(this, new DefaultCompass((CompassMapping)copyCompassMapping, (ConverterLookup)converterLookup, copyMetaData, propertyNamingStrategy, executorManager, copySettings));
    }

    protected void registerExtraConverters(ConverterLookup converterLookup) {
    }

    public CompassConfiguration configure() throws ConfigurationException {
        this.configure("/compass.cfg.xml");
        return this;
    }

    public CompassConfiguration configure(String resource) throws ConfigurationException {
        log.info((Object)("Configuring from resource [" + resource + "]"));
        this.configurationBuilder.configure(resource, this);
        return this;
    }

    public CompassConfiguration configure(URL url) throws ConfigurationException {
        log.info((Object)("Configuring from url [" + url.toExternalForm() + "]"));
        this.configurationBuilder.configure(url, this);
        return this;
    }

    public CompassConfiguration configure(File configFile) throws ConfigurationException {
        log.info((Object)("Configuring from file [" + configFile.getAbsolutePath() + "]"));
        this.configurationBuilder.configure(configFile, this);
        return this;
    }

    public CompassConfiguration addResourceMapping(ResourceMapping resourceMapping) {
        boolean hasAddedResource = this.getMappingBinding().addResourceMapping(resourceMapping);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match resource mapping [" + resourceMapping.getAlias() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Adding Resource Mapping [" + resourceMapping.getAlias() + "]"));
        }
        return this;
    }

    public CompassConfiguration removeMappingByAlias(String alias) throws MappingException {
        boolean removed = this.mapping.removeMappingByAlias(alias);
        if (removed && log.isInfoEnabled()) {
            log.info((Object)("Removing Resource Mapping with alias [" + alias + "]"));
        }
        return this;
    }

    public CompassConfiguration removeMappingByClass(Class clazz) throws MappingException {
        return this.removeMappingByClass(clazz.getName());
    }

    public CompassConfiguration removeMappingByClass(String className) throws MappingException {
        boolean removed = this.mapping.removeMappingByClass(className);
        if (removed && log.isInfoEnabled()) {
            log.info((Object)("Removing Resource Mappings with class [" + className + "]"));
        }
        return this;
    }

    public CompassConfiguration addMappingResover(InputStreamMappingResolver mappingResolver) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addMappingResolver(mappingResolver);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match mapping resolver [" + mappingResolver + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping resolver [" + mappingResolver + "]"));
        }
        return this;
    }

    public CompassConfiguration addResource(String path, ClassLoader classLoader) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addResource(path, classLoader);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match resource [" + path + "] and class loader [" + classLoader + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping resource [" + path + "] from class loader [" + classLoader + "]"));
        }
        return this;
    }

    public CompassConfiguration addResource(String path) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addResource(path, this.getClassLoader());
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match resource [" + path + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping resource [" + path + "] in class loader"));
        }
        return this;
    }

    public CompassConfiguration addFile(String filePath) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addFile(filePath);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match file [" + filePath + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping file [" + filePath + "]"));
        }
        return this;
    }

    public CompassConfiguration addFile(File file) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addFile(file);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match file [" + file.getAbsolutePath() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping file [" + file.getAbsolutePath() + "]"));
        }
        return this;
    }

    public CompassConfiguration addPackage(String packageName) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addPackage(packageName);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match package [" + packageName + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping package [" + packageName + "]"));
        }
        return this;
    }

    public CompassConfiguration addClass(Class searchableClass) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addClass(searchableClass);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match class [" + searchableClass.getName() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping class [" + searchableClass + "]"));
        }
        return this;
    }

    public CompassConfiguration addScan(String basePackage) throws ConfigurationException {
        return this.addScan(basePackage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompassConfiguration addScan(String basePackage, final String pattern) throws ConfigurationException {
        Enumeration<URL> urls;
        basePackage = basePackage.replace('.', '/');
        try {
            urls = this.settings.getClassLoader().getResources(basePackage);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to list resource for base package [" + basePackage + "]", e);
        }
        final AntPathMatcher matcher = new AntPathMatcher();
        final boolean performMatch = pattern != null && matcher.isPattern(pattern);
        Filter filter = new Filter(){

            public boolean accepts(String name) {
                for (String suffix : CompassConfiguration.this.getMappingBinding().getSuffixes()) {
                    if (performMatch && !matcher.match(pattern, name)) {
                        return false;
                    }
                    if (!name.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }
        };
        while (urls.hasMoreElements()) {
            Scanner scanner;
            URL url = urls.nextElement();
            try {
                scanner = ScannerFactoy.create(basePackage, url, filter);
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to create scan factory for basePackage [" + basePackage + "] and url [" + url + "]", e);
            }
            try {
                ScanItem si;
                while ((si = scanner.next()) != null) {
                    try {
                        this.getMappingBinding().addInputStream(si.getInputStream(), si.getName());
                    }
                    finally {
                        si.close();
                    }
                }
            }
            finally {
                scanner.close();
            }
        }
        return this;
    }

    public boolean tryAddClass(Class searchableClass) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addClass(searchableClass);
        if (log.isInfoEnabled() && hasAddedResource) {
            log.info((Object)("Mapping class [" + searchableClass + "]"));
        }
        return hasAddedResource;
    }

    public CompassConfiguration addDirectory(File dir) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addDirectory(dir);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match directory [" + dir.getAbsolutePath() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping directory [" + dir.getAbsolutePath() + "]"));
        }
        return this;
    }

    public CompassConfiguration addJar(File jar) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addJar(jar);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match jar [" + jar.getAbsolutePath() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping jar [" + jar.getName() + "]"));
        }
        return this;
    }

    public CompassConfiguration addURL(URL url) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addURL(url);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match URL [" + url.toExternalForm() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping URL [" + url.toExternalForm() + "]"));
        }
        return this;
    }

    public CompassConfiguration addInputStream(InputStream inputStream, String resourceName) throws ConfigurationException {
        boolean hasAddedResource = this.getMappingBinding().addInputStream(inputStream, resourceName);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match input stream [" + resourceName + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping InputStream [" + resourceName + "]"));
        }
        return this;
    }

    private class ConverterHolder {
        Class type;
        Converter converter;

        public ConverterHolder(Converter converter) {
            this.converter = converter;
        }

        private ConverterHolder(Class type, Converter converter) {
            this.type = type;
            this.converter = converter;
        }
    }
}

