/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.MultipleMapping;
import org.compass.core.mapping.internal.InternalResourcePropertyMapping;

public class NullValueMappingProcessor
implements MappingProcessor {
    private String globalNullValue;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.globalNullValue = settings.getSetting("compass.nullvalue");
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            this.processMapping(aliasMapping);
        }
        return compassMapping;
    }

    private void processMapping(Mapping mapping) throws MappingException {
        if (mapping instanceof InternalResourcePropertyMapping) {
            InternalResourcePropertyMapping resourcePropertyMapping = (InternalResourcePropertyMapping)mapping;
            if (!resourcePropertyMapping.hasNullValue()) {
                resourcePropertyMapping.setNullValue(this.globalNullValue);
            } else if ("$disable$".equals(resourcePropertyMapping.getNullValue())) {
                resourcePropertyMapping.setNullValue(null);
            }
        }
        if (mapping instanceof MultipleMapping) {
            MultipleMapping multipleMapping = (MultipleMapping)mapping;
            Iterator<Mapping> it = multipleMapping.mappingsIt();
            while (it.hasNext()) {
                this.processMapping(it.next());
            }
        }
    }
}

