/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.json.impl;

import java.io.IOException;
import java.io.Writer;
import org.compass.core.json.impl.DefaultJSONException;
import org.compass.core.json.impl.DefaultJSONObject;

public class DefaultJSONWriter {
    private static final int maxdepth = 20;
    private boolean comma = false;
    protected char mode = (char)105;
    private char[] stack = new char[20];
    private int top = 0;
    protected Writer writer;

    public DefaultJSONWriter(Writer w) {
        this.writer = w;
    }

    private DefaultJSONWriter append(String s) throws DefaultJSONException {
        if (s == null) {
            throw new DefaultJSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new DefaultJSONException(e);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new DefaultJSONException("Value out of sequence.");
    }

    public DefaultJSONWriter array() throws DefaultJSONException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new DefaultJSONException("Misplaced array.");
    }

    private DefaultJSONWriter end(char m, char c) throws DefaultJSONException {
        if (this.mode != m) {
            throw new DefaultJSONException(m == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new DefaultJSONException(e);
        }
        this.comma = true;
        return this;
    }

    public DefaultJSONWriter endArray() throws DefaultJSONException {
        return this.end('a', ']');
    }

    public DefaultJSONWriter endObject() throws DefaultJSONException {
        return this.end('k', '}');
    }

    public DefaultJSONWriter key(String s) throws DefaultJSONException {
        if (s == null) {
            throw new DefaultJSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(DefaultJSONObject.quote(s));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e) {
                throw new DefaultJSONException(e);
            }
        }
        throw new DefaultJSONException("Misplaced key.");
    }

    public DefaultJSONWriter object() throws DefaultJSONException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            return this;
        }
        throw new DefaultJSONException("Misplaced object.");
    }

    private void pop(char c) throws DefaultJSONException {
        if (this.top <= 0 || this.stack[this.top - 1] != c) {
            throw new DefaultJSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c) throws DefaultJSONException {
        if (this.top >= 20) {
            throw new DefaultJSONException("Nesting too deep.");
        }
        this.stack[this.top] = c;
        this.mode = c;
        ++this.top;
    }

    public DefaultJSONWriter value(boolean b) throws DefaultJSONException {
        return this.append(b ? "true" : "false");
    }

    public DefaultJSONWriter value(double d) throws DefaultJSONException {
        return this.value(new Double(d));
    }

    public DefaultJSONWriter value(long l) throws DefaultJSONException {
        return this.append(Long.toString(l));
    }

    public DefaultJSONWriter value(Object o) throws DefaultJSONException {
        return this.append(DefaultJSONObject.valueToString(o));
    }
}

