/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json;

import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.internal.InternalOverrideByNameMapping;
import org.compass.core.mapping.json.JsonMapping;
import org.compass.core.mapping.support.AbstractResourcePropertyMapping;
import org.compass.core.util.Parameter;

public class JsonPropertyMapping
extends AbstractResourcePropertyMapping
implements JsonMapping,
ResourcePropertyMapping,
InternalOverrideByNameMapping {
    private boolean overrideByName = false;
    private Converter valueConverter;
    private String valueConverterName;
    private String format;
    private String fullPath;
    private NamingType namingType = NamingType.PLAIN;
    private boolean dynamic = false;

    public Mapping copy() {
        JsonPropertyMapping xmlPropertyMapping = new JsonPropertyMapping();
        this.copy(xmlPropertyMapping);
        return xmlPropertyMapping;
    }

    protected void copy(JsonPropertyMapping copy) {
        super.copy(copy);
        copy.setOverrideByName(this.isOverrideByName());
        copy.setValueConverter(this.getValueConverter());
        copy.setValueConverterName(this.getValueConverterName());
        copy.setFormat(this.getFormat());
        copy.setFullPath(this.getFullPath());
        copy.setNamingType(this.getNamingType());
        copy.setDynamic(this.isDynamic());
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public boolean isOverrideByName() {
        return this.overrideByName;
    }

    public void setOverrideByName(boolean overrideByName) {
        this.overrideByName = overrideByName;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public String getValueConverterName() {
        return this.valueConverterName;
    }

    public void setValueConverterName(String valueConverterName) {
        this.valueConverterName = valueConverterName;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public NamingType getNamingType() {
        return this.namingType;
    }

    public void setNamingType(NamingType namingType) {
        this.namingType = namingType;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public ResourcePropertyConverter getResourcePropertyConverter() {
        if (this.valueConverter instanceof ResourcePropertyConverter) {
            return (ResourcePropertyConverter)this.valueConverter;
        }
        return null;
    }

    public static final class NamingType
    extends Parameter {
        public static final NamingType PLAIN = new NamingType("PLAIN");
        public static final NamingType FULL = new NamingType("FULL");

        private NamingType(String name) {
            super(name);
        }

        public static String toString(NamingType namingType) {
            if (namingType == PLAIN) {
                return "plain";
            }
            if (namingType == FULL) {
                return "full";
            }
            throw new IllegalArgumentException("Can't find naming type for [" + namingType + "]");
        }

        public static NamingType fromString(String namingType) {
            if ("plain".equalsIgnoreCase(namingType)) {
                return PLAIN;
            }
            if ("full".equalsIgnoreCase(namingType)) {
                return FULL;
            }
            throw new IllegalArgumentException("Can't find naming type for [" + namingType + "]");
        }
    }
}

