/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.json.JsonArrayMapping;
import org.compass.core.mapping.json.JsonContentMapping;
import org.compass.core.mapping.json.JsonMapping;
import org.compass.core.mapping.json.JsonMappingIterator;
import org.compass.core.mapping.json.JsonObjectMapping;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.PlainJsonObjectMapping;
import org.compass.core.mapping.support.AbstractResourceMapping;

public class RootJsonObjectMapping
extends AbstractResourceMapping
implements JsonObjectMapping {
    private ResourcePropertyMapping[] resourcePropertyMappings;
    private Map<String, ResourcePropertyMapping> resourcePropertyMappingsByPath = new HashMap<String, ResourcePropertyMapping>();
    private JsonContentMapping contentMapping;
    private String fullPath;
    private boolean dynamic = false;

    public Mapping copy() {
        RootJsonObjectMapping copy = new RootJsonObjectMapping();
        super.copy(copy);
        copy.setFullPath(this.getFullPath());
        copy.setDynamic(this.isDynamic());
        return copy;
    }

    public AliasMapping shallowCopy() {
        RootJsonObjectMapping copy = new RootJsonObjectMapping();
        super.shallowCopy(copy);
        copy.setFullPath(this.getFullPath());
        copy.setDynamic(this.isDynamic());
        return copy;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public int addMapping(Mapping mapping) {
        if (mapping instanceof JsonContentMapping) {
            this.contentMapping = (JsonContentMapping)mapping;
        }
        return super.addMapping(mapping);
    }

    protected void doPostProcess() throws MappingException {
        ResourcePropertyMappingGatherer resourcePropertyMappingGatherer = new ResourcePropertyMappingGatherer();
        JsonMappingIterator.iterateMappings((JsonMappingIterator.JsonMappingCallback)resourcePropertyMappingGatherer, this, true);
        for (ResourcePropertyMapping m : this.resourcePropertyMappings = resourcePropertyMappingGatherer.getResourcePropertyMappings()) {
            if (m.isInternal() || !(m instanceof JsonMapping)) continue;
            JsonMapping jsonMapping = (JsonMapping)((Object)m);
            this.resourcePropertyMappingsByPath.put(jsonMapping.getFullPath(), m);
        }
    }

    public ResourcePropertyMapping[] getResourcePropertyMappings() {
        return this.resourcePropertyMappings;
    }

    public ResourcePropertyMapping getResourcePropertyMappingByDotPath(String path) {
        return this.resourcePropertyMappingsByPath.get(path);
    }

    public JsonContentMapping getContentMapping() {
        return this.contentMapping;
    }

    private class ResourcePropertyMappingGatherer
    implements JsonMappingIterator.JsonMappingCallback {
        private ArrayList<ResourcePropertyMapping> resourcePropertyMappings = new ArrayList();

        private ResourcePropertyMappingGatherer() {
        }

        public ResourcePropertyMapping[] getResourcePropertyMappings() {
            return this.resourcePropertyMappings.toArray(new ResourcePropertyMapping[this.resourcePropertyMappings.size()]);
        }

        public void onJsonRootObject(RootJsonObjectMapping jsonObjectMapping) {
        }

        public void onJsonObject(PlainJsonObjectMapping jsonObjectMapping) {
        }

        public void onJsonContent(JsonContentMapping jsonContentMapping) {
        }

        public void onJsonProperty(JsonPropertyMapping jsonPropertyMapping) {
            this.resourcePropertyMappings.add(jsonPropertyMapping);
        }

        public void onJsonArray(JsonArrayMapping jsonArrayMapping) {
        }

        public boolean onBeginMultipleMapping(JsonMapping mapping) {
            return true;
        }

        public void onEndMultipleMapping(JsonMapping mapping) {
        }
    }
}

