/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.internal.PostProcessingMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.IdComponentMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.OsemMappingIterator;
import org.compass.core.mapping.support.AbstractResourceMapping;
import org.compass.core.util.Assert;
import org.compass.core.util.reflection.ReflectionConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMapping
extends AbstractResourceMapping
implements ResourceMapping,
PostProcessingMapping {
    private ClassPropertyMapping.ManagedId managedId;
    private PropertyPath enumNamePath;
    private PropertyPath classPath;
    private PropertyPath basePath;
    private Class clazz;
    private boolean poly;
    private Class polyClass;
    private Boolean supportUnmarshall;
    private Boolean filterDuplicates;
    private ResourcePropertyMapping[] resourcePropertyMappings;
    private ClassPropertyMapping[] classPropertyMappings;
    private ClassIdPropertyMapping[] classIdPropertyMappings;
    private HashMap<String, ResourcePropertyMapping> pathMappings;
    private ReflectionConstructor constructor;
    private ReflectionConstructor polyConstructor;

    @Override
    public Mapping copy() {
        ClassMapping copy = new ClassMapping();
        super.copy(copy);
        copy.setPoly(this.isPoly());
        copy.setClassPath(this.getClassPath());
        copy.setEnumNamePath(this.getEnumNamePath());
        copy.setClazz(this.getClazz());
        copy.setPolyClass(this.getPolyClass());
        copy.setConstructor(this.getConstructor());
        copy.setPolyConstructor(this.getPolyConstructor());
        copy.supportUnmarshall = this.supportUnmarshall;
        copy.filterDuplicates = this.filterDuplicates;
        copy.setManagedId(this.getManagedId());
        copy.setBasePath(this.getBasePath());
        return copy;
    }

    @Override
    public AliasMapping shallowCopy() {
        ClassMapping copy = new ClassMapping();
        super.shallowCopy(copy);
        copy.setPoly(this.isPoly());
        copy.setClassPath(this.getClassPath());
        copy.setEnumNamePath(this.getEnumNamePath());
        copy.setClazz(this.getClazz());
        copy.setPolyClass(this.getPolyClass());
        copy.setConstructor(this.getConstructor());
        copy.setPolyConstructor(this.getPolyConstructor());
        copy.supportUnmarshall = this.supportUnmarshall;
        copy.filterDuplicates = this.filterDuplicates;
        copy.setManagedId(this.getManagedId());
        copy.setBasePath(this.getBasePath());
        return copy;
    }

    @Override
    protected void doPostProcess() throws MappingException {
        PostProcessMappingCallback callback = new PostProcessMappingCallback();
        OsemMappingIterator.iterateMappings(callback, this, true);
        this.resourcePropertyMappings = callback.getResourcePropertyMappings().toArray(new ResourcePropertyMapping[callback.getResourcePropertyMappings().size()]);
        this.classPropertyMappings = callback.getClassPropertyMappings().toArray(new ClassPropertyMapping[callback.getClassPropertyMappings().size()]);
        List<ClassIdPropertyMapping> idMappings = this.findClassPropertyIdMappings();
        this.classIdPropertyMappings = idMappings.toArray(new ClassIdPropertyMapping[idMappings.size()]);
        this.pathMappings = callback.getPathMappings();
    }

    @Override
    public ResourcePropertyMapping[] getResourcePropertyMappings() {
        return this.resourcePropertyMappings;
    }

    public ClassPropertyMapping[] getClassPropertyMappings() {
        return this.classPropertyMappings;
    }

    public ClassIdPropertyMapping[] getClassIdPropertyMappings() {
        return this.classIdPropertyMappings;
    }

    public List<Mapping> findIdMappings() {
        ArrayList<Mapping> idMappingList = new ArrayList<Mapping>();
        Iterator<Mapping> it = this.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            if (m instanceof ClassIdPropertyMapping) {
                idMappingList.add(m);
            }
            if (!(m instanceof IdComponentMapping)) continue;
            idMappingList.add(m);
        }
        return idMappingList;
    }

    public List<ClassPropertyMapping> findClassPropertiesRequireProcessing() {
        ArrayList<ClassPropertyMapping> idMappingList = new ArrayList<ClassPropertyMapping>();
        Iterator<Mapping> it = this.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            if (m instanceof ClassIdPropertyMapping) {
                idMappingList.add((ClassIdPropertyMapping)m);
                continue;
            }
            if (m instanceof IdComponentMapping) {
                IdComponentMapping idComponentMapping = (IdComponentMapping)m;
                idMappingList.addAll(idComponentMapping.getRefClassMappings()[0].findClassPropertyIdMappings());
                continue;
            }
            if (!(m instanceof ClassPropertyMapping) || !((ClassPropertyMapping)m).requiresIdProcessing()) continue;
            idMappingList.add((ClassPropertyMapping)m);
        }
        return idMappingList;
    }

    public List<ClassIdPropertyMapping> findClassPropertyIdMappings() {
        ArrayList<ClassIdPropertyMapping> idMappingList = new ArrayList<ClassIdPropertyMapping>();
        Iterator<Mapping> it = this.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            if (m instanceof ClassIdPropertyMapping) {
                idMappingList.add((ClassIdPropertyMapping)m);
            }
            if (!(m instanceof IdComponentMapping)) continue;
            IdComponentMapping idComponentMapping = (IdComponentMapping)m;
            idMappingList.addAll(idComponentMapping.getRefClassMappings()[0].findClassPropertyIdMappings());
        }
        return idMappingList;
    }

    @Override
    public ResourcePropertyMapping getResourcePropertyMappingByDotPath(String path) {
        return this.pathMappings.get(path);
    }

    public ClassPropertyMapping.ManagedId getManagedId() {
        return this.managedId;
    }

    public void setManagedId(ClassPropertyMapping.ManagedId managedId) {
        this.managedId = managedId;
    }

    public boolean isPoly() {
        return this.poly;
    }

    public void setPoly(boolean poly) {
        this.poly = poly;
    }

    public PropertyPath getClassPath() {
        return this.classPath;
    }

    public void setClassPath(PropertyPath classPath) {
        this.classPath = classPath;
    }

    public PropertyPath getEnumNamePath() {
        return this.enumNamePath;
    }

    public void setEnumNamePath(PropertyPath enumNamePath) {
        this.enumNamePath = enumNamePath;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public Class getPolyClass() {
        return this.polyClass;
    }

    public void setPolyClass(Class polyClass) {
        this.polyClass = polyClass;
    }

    public boolean isSupportUnmarshall() {
        return this.supportUnmarshall;
    }

    public void setSupportUnmarshall(boolean supportUnmarshall) {
        this.supportUnmarshall = supportUnmarshall;
    }

    public boolean isSupportUnmarshallSet() {
        return this.supportUnmarshall != null;
    }

    public Boolean isFilterDuplicates() {
        return this.filterDuplicates;
    }

    public void setFilterDuplicates(Boolean filterDuplicates) {
        this.filterDuplicates = filterDuplicates;
    }

    public ReflectionConstructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ReflectionConstructor constructor) {
        this.constructor = constructor;
    }

    public ReflectionConstructor getPolyConstructor() {
        return this.polyConstructor;
    }

    public void setPolyConstructor(ReflectionConstructor polyConstructor) {
        this.polyConstructor = polyConstructor;
    }

    public PropertyPath getBasePath() {
        return this.basePath;
    }

    public void setBasePath(PropertyPath basePath) {
        this.basePath = basePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PostProcessMappingCallback
    extends OsemMappingIterator.ClassPropertyAndResourcePropertyGatherer {
        private HashMap<String, ResourcePropertyMapping> pathMappings = new HashMap();
        private ArrayList<String> pathSteps = new ArrayList();
        private StringBuilder sb = new StringBuilder();
        private Set<String> cyclicClassMappings = new HashSet<String>();

        @Override
        public boolean onBeginClassMapping(ClassMapping classMapping) {
            if (classMapping.isSupportUnmarshall()) {
                return true;
            }
            if (this.cyclicClassMappings.contains(classMapping.getAlias())) {
                return false;
            }
            this.cyclicClassMappings.add(classMapping.getAlias());
            return true;
        }

        @Override
        public void onEndClassMapping(ClassMapping classMapping) {
            if (classMapping.isSupportUnmarshall()) {
                return;
            }
            this.cyclicClassMappings.remove(classMapping.getAlias());
        }

        @Override
        protected void onDuplicateMapping(ClassMapping classMapping, ObjectMapping actualMapping, ObjectMapping duplicateMapping) {
            Assert.isTrue(actualMapping.getPropertyName().equals(duplicateMapping.getPropertyName()), "Internal Error in Compass, Original[" + duplicateMapping.getName() + "] does not equal [" + actualMapping.getName() + "]");
            int index = classMapping.mappings.indexOf(duplicateMapping);
            if (index < 0) {
                for (int i = 0; i < classMapping.mappings.size(); ++i) {
                    AbstractCollectionMapping temp;
                    Object o = classMapping.mappings.get(i);
                    if (!(o instanceof AbstractCollectionMapping) || (temp = (AbstractCollectionMapping)o).getElementMapping() != duplicateMapping) continue;
                    temp.setElementMapping(actualMapping);
                    index = i;
                    break;
                }
            } else {
                classMapping.mappingsByNameMap.put(duplicateMapping.getName(), actualMapping);
                classMapping.mappings.set(index, actualMapping);
            }
            if (index < 0) {
                throw new IllegalStateException("Internal Error in Compass, original mapping [" + duplicateMapping.getName() + "] not found");
            }
        }

        private void addToPath(String name) {
            this.pathSteps.add(name);
        }

        private void removeFromPath() {
            if (this.pathSteps.size() > 0) {
                this.pathSteps.remove(this.pathSteps.size() - 1);
            }
        }

        @Override
        public boolean onBeginMultipleMapping(ClassMapping classMapping, Mapping mapping) {
            boolean retVal = super.onBeginMultipleMapping(classMapping, mapping);
            this.addToPath(mapping.getName());
            return retVal;
        }

        @Override
        public void onEndMultiplMapping(ClassMapping classMapping, Mapping mapping) {
            super.onEndMultiplMapping(classMapping, mapping);
            this.removeFromPath();
        }

        @Override
        public void onClassPropertyMapping(ClassMapping classMapping, ClassPropertyMapping mapping) {
            super.onClassPropertyMapping(classMapping, mapping);
            ResourcePropertyMapping resourcePropertyMapping = mapping.getIdMapping();
            if (resourcePropertyMapping == null && mapping.mappingsSize() > 0) {
                resourcePropertyMapping = (ResourcePropertyMapping)mapping.mappingsIt().next();
            }
            this.pathMappings.put(this.currentPath(), resourcePropertyMapping);
        }

        @Override
        public void onResourcePropertyMapping(ResourcePropertyMapping mapping) {
            super.onResourcePropertyMapping(mapping);
            if (!mapping.isInternal()) {
                this.addToPath(mapping.getName());
            }
            this.pathMappings.put(this.currentPath(), mapping);
            if (!mapping.isInternal()) {
                this.removeFromPath();
            }
            if (mapping instanceof ClassPropertyMetaDataMapping) {
                if (!mapping.isInternal()) {
                    this.addToPath(((ClassPropertyMetaDataMapping)mapping).getOriginalName());
                }
                this.pathMappings.put(this.currentPath(), mapping);
                if (!mapping.isInternal()) {
                    this.removeFromPath();
                }
            }
        }

        public HashMap<String, ResourcePropertyMapping> getPathMappings() {
            return this.pathMappings;
        }

        private String currentPath() {
            this.sb.setLength(0);
            for (int i = 0; i < this.pathSteps.size(); ++i) {
                if (i > 0) {
                    this.sb.append('.');
                }
                this.sb.append(this.pathSteps.get(i));
            }
            return this.sb.toString();
        }

        class NoUnmarshallHolder {
            ClassMapping parent;
            ClassMapping classMapping;

            NoUnmarshallHolder(ClassMapping parent, ClassMapping classMapping) {
                this.parent = parent;
                this.classMapping = classMapping;
            }
        }
    }
}

