/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.asm.optimizer;

import org.compass.core.util.asm.AnnotationVisitor;
import org.compass.core.util.asm.Attribute;
import org.compass.core.util.asm.FieldVisitor;
import org.compass.core.util.asm.optimizer.AnnotationConstantsCollector;
import org.compass.core.util.asm.optimizer.ConstantPool;

public class FieldConstantsCollector
implements FieldVisitor {
    private final FieldVisitor fv;
    private final ConstantPool cp;

    public FieldConstantsCollector(FieldVisitor fv, ConstantPool cp) {
        this.fv = fv;
        this.cp = cp;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.fv.visitAnnotation(desc, visible), this.cp);
    }

    public void visitAttribute(Attribute attr) {
        this.fv.visitAttribute(attr);
    }

    public void visitEnd() {
        this.fv.visitEnd();
    }
}

