/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.compass.core.config.ConfigurationException;
import org.compass.core.json.JsonArray;
import org.compass.core.json.JsonObject;
import org.compass.core.json.impl.DefaultJSONObject;
import org.compass.core.json.impl.DefaultJSONTokener;
import org.compass.core.util.CopyUtils;
import org.compass.core.util.config.ConfigurationHelper;
import org.compass.core.util.config.PlainConfigurationHelper;

public class JsonConfigurationHelperBuilder {
    public ConfigurationHelper buildFromFile(String filename) throws ConfigurationException {
        return this.buildFromFile(new File(filename));
    }

    public ConfigurationHelper buildFromFile(File file) throws ConfigurationException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Failed to find file [" + file.getAbsolutePath() + "]");
        }
        return this.build(inputStream, file.getAbsolutePath());
    }

    public ConfigurationHelper build(InputStream inputStream, String systemId) throws ConfigurationException {
        return this.build(new InputStreamReader(inputStream), systemId);
    }

    public ConfigurationHelper build(Reader reader, String systemId) {
        DefaultJSONObject jsonObject;
        try {
            String json = CopyUtils.copyToString(reader);
            jsonObject = new DefaultJSONObject(new DefaultJSONTokener(json));
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse JSON document [" + systemId + "]", e);
        }
        PlainConfigurationHelper confHelper = new PlainConfigurationHelper("root", systemId);
        this.process(confHelper, jsonObject);
        if (confHelper.getChildren().length == 1) {
            return confHelper.getChildren()[0];
        }
        return confHelper;
    }

    private void process(PlainConfigurationHelper confHelper, JsonObject jsonObject) {
        Iterator<String> keyIt = jsonObject.keys();
        while (keyIt.hasNext()) {
            String key = keyIt.next();
            Object value = jsonObject.opt(key);
            if (value == null) continue;
            if (value instanceof JsonObject) {
                PlainConfigurationHelper childConfHelper = new PlainConfigurationHelper(key);
                this.process(childConfHelper, (JsonObject)value);
                confHelper.addChild(childConfHelper);
                continue;
            }
            if (value instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)value;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    PlainConfigurationHelper childConfHelper;
                    value = jsonArray.opt(i);
                    if (value == null || jsonArray.isNull(i)) continue;
                    if (value instanceof JsonObject) {
                        childConfHelper = new PlainConfigurationHelper(key);
                        this.process(childConfHelper, (JsonObject)value);
                        confHelper.addChild(childConfHelper);
                        continue;
                    }
                    if (value instanceof JsonArray) {
                        throw new ConfigurationException("Parsing of JSON does not support array within an array");
                    }
                    childConfHelper = new PlainConfigurationHelper(key);
                    childConfHelper.setValue(value.toString());
                    confHelper.addChild(childConfHelper);
                }
                continue;
            }
            confHelper.setAttribute(key, value.toString());
        }
    }
}

